package mod.azure.azurelib.common.api.client.helper;

import mod.azure.azurelib.common.internal.client.renderer.GeoRenderer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.lwjgl.glfw.GLFW;

/**
 * Helper class for segregating client-side code
 */
public final class ClientUtils {

    /**
     * Translates the provided {@link class_4587} to face towards the given {@link class_1297}'s rotation.<br>
     * Usually used for rotating projectiles towards their trajectory, in an {@link GeoRenderer#preRender} override.<br>
     */
    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439(partialTick, animatable.field_5982, animatable.method_36454()) - 90));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439(partialTick, animatable.field_6004, animatable.method_36455())));
    }

    /**
     * Get the player on the client
     */
    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    /**
     * Gets the current level on the client
     */
    public static class_1937 getLevel() {
        return class_310.method_1551().field_1687;
    }

    /**
     * Common reload KeyMapping for my various mods
     */
    public static class_304 RELOAD;

    /**
     * Common scope KeyMapping for my various mods
     */
    public static class_304 SCOPE;

    /**
     * Common scope KeyMapping for my various mods
     */
    public static class_304 FIRE_WEAPON;
}
