package mod.azure.azurelib.common.api.client.model;

import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import net.minecraft.class_2960;

/**
 * {@link DefaultedGeoModel} specific to {@link net.minecraft.class_1792 Items}.
 * Using this class pre-sorts provided asset paths into the "item" subdirectory
 */
public class DefaultedItemGeoModel<T extends GeoAnimatable> extends DefaultedGeoModel<T> {
	/**
	 * Create a new instance of this model class.<br>
	 * The asset path should be the truncated relative path from the base folder.<br>
	 * E.G.
	 * <pre>{@code
	 * 	new ResourceLocation("myMod", "armor/obsidian")
	 * }</pre>
	 */
	public DefaultedItemGeoModel(class_2960 assetSubpath) {
		super(assetSubpath);
	}

	@Override
	protected String subtype() {
		return "item";
	}

	/**
	 * Changes the constructor-defined model path for this model to an alternate.<br>
	 * This is useful if your animatable shares a model path with another animatable that differs in path to the texture and animations for this model
	 */
	@Override
	public DefaultedItemGeoModel<T> withAltModel(class_2960 altPath) {
		return (DefaultedItemGeoModel<T>)super.withAltModel(altPath);
	}

	/**
	 * Changes the constructor-defined animations path for this model to an alternate.<br>
	 * This is useful if your animatable shares an animations path with another animatable that differs in path to the model and texture for this model
	 */
	@Override
	public DefaultedItemGeoModel<T> withAltAnimations(class_2960 altPath) {
		return (DefaultedItemGeoModel<T>)super.withAltAnimations(altPath);
	}

	/**
	 * Changes the constructor-defined texture path for this model to an alternate.<br>
	 * This is useful if your animatable shares a texture path with another animatable that differs in path to the model and animations for this model
	 */
	@Override
	public DefaultedItemGeoModel<T> withAltTexture(class_2960 altPath) {
		return (DefaultedItemGeoModel<T>)super.withAltTexture(altPath);
	}
}
