package mod.azure.azurelib.common.api.client.renderer.layer;

import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import mod.azure.azurelib.common.internal.client.renderer.GeoRenderer;
import org.apache.logging.log4j.util.TriConsumer;

/**
 * {@link GeoRenderLayer} for auto-applying some form of modification to bones of a model prior to rendering.<br>
 * This can be useful for enabling or disabling bone rendering based on arbitrary conditions.<br>
 * <br>
 * NOTE: Despite this layer existing, it is much more efficient to use {@link FastBoneFilterGeoLayer} instead
 */
public class BoneFilterGeoLayer<T extends GeoAnimatable> extends GeoRenderLayer<T> {
	protected final TriConsumer<GeoBone, T, Float> checkAndApply;

	public BoneFilterGeoLayer(GeoRenderer<T> renderer) {
		this(renderer, (bone, animatable, partialTick) -> {});
	}

	public BoneFilterGeoLayer(GeoRenderer<T> renderer, TriConsumer<GeoBone, T, Float> checkAndApply) {
		super(renderer);

		this.checkAndApply = checkAndApply;
	}

	/**
	 * This method is called for each bone in the model.<br>
	 * Check whether the bone should be affected and apply the modification as needed.
	 */
	protected void checkAndApply(GeoBone bone, T animatable, float partialTick) {
		this.checkAndApply.accept(bone, animatable, partialTick);
	}

	@Override
	public void preRender(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
		for (GeoBone bone : bakedModel.topLevelBones()) {
			checkChildBones(bone, animatable, partialTick);
		}
	}

	private void checkChildBones(GeoBone parentBone, T animatable, float partialTick) {
		checkAndApply(parentBone, animatable, partialTick);

		for (GeoBone bone : parentBone.getChildBones()) {
			checkChildBones(bone, animatable, partialTick);
		}
	}
}
