package mod.azure.azurelib.common.api.common.animatable;

import java.util.function.Consumer;
import java.util.function.Supplier;

import mod.azure.azurelib.common.internal.common.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationController;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.Nullable;

import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimTriggerPacket;

/**
 * The {@link GeoAnimatable} interface specific to {@link class_1297 Entities}. This interface is <u>specifically</u> for entities replacing the rendering of other, existing entities.
 */
public interface GeoReplacedEntity extends SingletonGeoAnimatable {
	/**
	 * Returns the {@link class_1299} this entity is intending to replace.<br>
	 * This is used for rendering an animation purposes.
	 */
	class_1299<?> getReplacingEntityType();

	/**
	 * Get server-synced animation data via its relevant {@link SerializableDataTicket}.<br>
	 * Should only be used on the <u>client-side</u>.<br>
	 * <b><u>DO NOT OVERRIDE</u></b>
	 * 
	 * @param entity     The entity instance relevant to the data being set
	 * @param dataTicket The data ticket for the data to retrieve
	 * @return The synced data, or null if no data of that type has been synced
	 */
	@Nullable
	default <D> D getAnimData(class_1297 entity, SerializableDataTicket<D> dataTicket) {
		return getAnimatableInstanceCache().getManagerForId(entity.method_5628()).getData(dataTicket);
	}

	/**
	 * Saves an arbitrary syncable piece of data to this animatable's {@link AnimatableManager}.<br>
	 * <b><u>DO NOT OVERRIDE</u></b>
	 * 
	 * @param relatedEntity An entity related to the state of the data for syncing
	 * @param dataTicket    The DataTicket to sync the data for
	 * @param data          The data to sync
	 */
	default <D> void setAnimData(class_1297 relatedEntity, SerializableDataTicket<D> dataTicket, D data) {
		if (relatedEntity.method_37908().method_8608()) {
			getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628()).setData(dataTicket, data);
		} else {
			EntityAnimDataSyncPacket<D> entityAnimDataSyncPacket = new EntityAnimDataSyncPacket<>(relatedEntity.method_5628(), dataTicket, data);
			Services.NETWORK.sendToTrackingEntityAndSelf(entityAnimDataSyncPacket, relatedEntity);
		}
	}

	/**
	 * Trigger an animation for this Entity, based on the controller name and animation name.<br>
	 * <b><u>DO NOT OVERRIDE</u></b>
	 * 
	 * @param relatedEntity  An entity related to the state of the data for syncing
	 * @param controllerName The name of the controller name the animation belongs to, or null to do an inefficient lazy search
	 * @param animName       The name of animation to trigger. This needs to have been registered with the controller via {@link AnimationController#triggerableAnim AnimationController.triggerableAnim}
	 */
	default void triggerAnim(class_1297 relatedEntity, @Nullable String controllerName, String animName) {
		if (relatedEntity.method_37908().method_8608()) {
			getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628()).tryTriggerAnimation(controllerName, animName);
		} else {
			EntityAnimTriggerPacket entityAnimTriggerPacket = new EntityAnimTriggerPacket(relatedEntity.method_5628(), controllerName, animName);
			Services.NETWORK.sendToTrackingEntityAndSelf(entityAnimTriggerPacket, relatedEntity);
		}
	}

	/**
	 * Returns the current age/tick of the animatable instance.<br>
	 * By default this is just the animatable's age in ticks, but this method allows for non-ticking custom animatables to provide their own values
	 * 
	 * @param entity The Entity representing this animatable
	 * @return The current tick/age of the animatable, for animation purposes
	 */
	@Override
	default double getTick(Object entity) {
		return ((class_1297) entity).field_6012;
	}

	// These methods aren't used for GeoReplacedEntity
	@Override
	default void createRenderer(Consumer<Object> consumer) {
	}

	// These methods aren't used for GeoReplacedEntity
	@Override
	default Supplier<Object> getRenderProvider() {
		return null;
	}
}
