package mod.azure.azurelib.common.api.common.entities;

import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1420;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5712.class_7397;
import net.minecraft.class_5716;
import net.minecraft.class_6335;
import net.minecraft.class_6862;
import net.minecraft.class_7260;
import net.minecraft.class_8514;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

/**
 * Custom Vibration class that removes the {@link class_7260} particle that usually spawns
 */
public class AzureVibrationUser implements class_8514.class_5719 {
    protected final class_1308 mob;
    protected final float moveSpeed;
    protected final int range;
    protected final class_5716 positionSource;

    public AzureVibrationUser(class_1308 entity, float speed, int range) {
        this.positionSource = new class_5709(entity, entity.method_5751());
        this.mob = entity;
        this.moveSpeed = speed;
        this.range = range;
    }

    @Override
    public int method_49797() {
        return range;
    }

    @Override
    public class_5716 method_51300() {
        return this.positionSource;
    }

    @Override
    public class_6862<class_5712> method_42210() {
        return class_5698.field_38079;
    }

    @Override
    public boolean method_43695() {
        return true;
    }

    @Override
    public boolean method_42324(class_5712 gameEvent, class_7397 context) {
        if (!gameEvent.method_40156(this.method_42210()))
            return false;

        var entity = context.comp_713();
        if (entity != null) {
            if (entity.method_7325())
                return false;
            if (entity.method_21749() && gameEvent.method_40156(class_5698.field_28091))
                return false;
            if (entity.method_33189())
                return false;
        }
        if (context.comp_714() != null)
            return !context.comp_714().method_26164(class_3481.field_38835);
        return true;
    }

    @Override
    public boolean method_32970(class_3218 serverLevel, class_2338 blockPos, class_5712 gameEvent, class_5712.class_7397 context) {
        if (mob.method_5987() || mob.method_29504() || !mob.method_37908().method_8621().method_11952(blockPos) || mob.method_31481())
            return false;
        var entity = context.comp_713();
        return !(entity instanceof class_1309) || canTargetEntity((class_1309) entity);
    }

    @Override
    public void method_32969(class_3218 serverLevel, class_2338 blockPos, class_5712 gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
        if (this.mob.method_29504())
            return;
        if (this.mob.method_5782())
            return;
    }

    @Contract(value = "null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309))
            return false;
        var livingEntity = (class_1309) entity;
        if (this.mob.method_37908() != entity.method_37908())
            return false;
        if (!class_1301.field_6156.test(entity))
            return false;
        if (this.mob.method_5782())
            return false;
        if (this.mob.method_5722(entity))
            return false;
        if (livingEntity.method_6046() == class_1310.field_6289)
            return false;
        if (livingEntity.method_5864() == class_1299.field_6131)
            return false;
        if (livingEntity.method_5864() == class_1299.field_38095)
            return false;
        if (livingEntity instanceof class_1420)
            return false;
        if (entity instanceof class_6335)
            return false;
        if (entity instanceof class_1295)
            return false;
        if (livingEntity.method_5655())
            return false;
        if (livingEntity.method_29504())
            return false;
        if (!this.mob.method_37908().method_8621().method_11966(livingEntity.method_5829()))
            return false;
        return true;
    }
}