package mod.azure.azurelib.common.api.common.helper;

import D;
import java.util.Optional;
import mod.azure.azurelib.common.internal.common.blocks.TickingLightEntity;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.common.platform.services.IPlatformHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public record CommonUtils() {

    /**
     * Summons an Area of Effect Cloud with the set particle, y offset, radius, duration, and effect options.
     *
     * @param entity     The Entity summoning the AoE
     * @param particle   Sets the Particle
     * @param yOffset    Set the yOffset if wanted
     * @param duration   Sets the duration of the AoE
     * @param radius     Sets the radius of the AoE
     * @param hasEffect  Should this have an effect?
     * @param effect     If it should effect, what effect?
     * @param effectTime How long the effect should be applied for?
     */
    public static void summonAoE(class_1309 entity, class_2394 particle, int yOffset, int duration, float radius, boolean hasEffect, @Nullable class_1291 effect, int effectTime) {
        var areaEffectCloudEntity = new class_1295(entity.method_37908(), entity.method_23317(), entity.method_23318() + yOffset,
                entity.method_23321());
        areaEffectCloudEntity.method_5603(radius);
        areaEffectCloudEntity.method_5604(duration);
        areaEffectCloudEntity.method_5608(particle);
        areaEffectCloudEntity.method_5596(
                -areaEffectCloudEntity.method_5599() / areaEffectCloudEntity.method_5605());
        if (hasEffect && effect != null && !entity.method_6059(effect))
            areaEffectCloudEntity.method_5610(new class_1293(effect, effectTime, 0));
        entity.method_37908().method_8649(areaEffectCloudEntity);
    }

    /**
     * Call wherever you are firing weapon to place the half tick light-block, making sure do so only on the server.
     *
     * @param entity         Usually the player or mob that is using the weapon
     * @param isInWaterBlock Checks if it's in a water block to refresh faster.
     */
    public static void spawnLightSource(class_1297 entity, boolean isInWaterBlock) {
        class_2338 lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = AzureLibUtil.findFreeSpace(entity.method_37908(), entity.method_24515(), 2);
            if (lightBlockPos == null) return;
            entity.method_37908().method_8501(lightBlockPos,
                    Services.PLATFORM.getTickingLightBlock().method_9564());
        } else if (AzureLibUtil.checkDistance(lightBlockPos, entity.method_24515(),
                2) && entity.method_37908().method_8321(lightBlockPos) instanceof TickingLightEntity tickingLightEntity) {
            tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
        }
    }

    /**
     * Hitscan between the player and the target. Useful for doing damage
     * TODO: Fix why it doesn't work if going about shoulder level on zombie sized mobs
     *
     * @param livingEntity The Shooter Entity.
     * @param range        The block distance it can fire.
     * @param ticks        The amount of ticks to take, usually will be 1.0f
     * @return returns a EntityHitResult
     */
    public static class_3966 hitscanTrace(class_1309 livingEntity, double range, float ticks) {
        var look = livingEntity.method_5828(ticks);
        var start = livingEntity.method_5836(ticks);
        var end = new class_243(livingEntity.method_23317() + look.field_1352 * range, livingEntity.method_23320() + look.field_1351 * range,
                livingEntity.method_23321() + look.field_1350 * range);
        var traceDistance = livingEntity.method_37908().method_17742(
                new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348,
                        livingEntity)).method_17784().method_1025(end);
        for (var possible : livingEntity.method_37908().method_8333(livingEntity,
                livingEntity.method_5829().method_18804(look.method_1021(traceDistance)).method_1012(3.0D, 3.0D, 3.0D),
                (entity -> !entity.method_7325() && entity.method_5863() && entity instanceof class_1309))) {
            var clip = possible.method_5829().method_1014(0.3D).method_992(start, end);
            if (clip.isPresent() && start.method_1025(clip.get()) < traceDistance)
                return class_1675.method_18077(livingEntity.method_37908(), livingEntity, start, end,
                        livingEntity.method_5829().method_18804(look.method_1021(traceDistance)).method_1009(3.0D, 3.0D,
                                3.0D),
                        target -> !target.method_7325() && livingEntity.method_5732() && livingEntity.method_6057(
                                target));
        }
        return null;
    }

    /**
     * Handles setting fire to targets when using the {@link IPlatformHelper#getIncendairyenchament()}
     *
     * @param projectile The Projectile being used
     */
    public static void setOnFire(class_1676 projectile) {
        if (projectile.method_5809())
            projectile.method_37908().method_18467(class_1309.class, projectile.method_5829().method_1014(2)).forEach(
                    e -> {
                        if (e.method_5805() && !(e instanceof class_1657)) e.method_20803(90);
                    });
    }
}
