package mod.azure.azurelib.common.api.common.interfaces;

import static java.lang.Math.min;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

/**
 * Interface of having entities grow into entity based a growth value.
 * @author Boston Vanseghi
 */
public interface Growable {
    float getGrowth();

    void setGrowth(float growth);

    float getMaxGrowth();

    default void grow(class_1309 entity, float amount) {
        setGrowth(min(getGrowth() + amount, getMaxGrowth()));
        if (getGrowth() >= getMaxGrowth())
            growUp(entity);
    }

    class_1309 growInto();

    default void growUp(class_1309 entity) {
        var world = entity.method_37908();
        if (!world.method_8608()) {
            var newEntity = growInto();
            if (newEntity == null)
                return;
            newEntity.method_5725(entity.method_24515(), entity.method_36454(), entity.method_36455());
            world.method_8649(newEntity);
            entity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    default float getGrowthNeededUntilGrowUp() {
        return getMaxGrowth() - getGrowth();
    }

    default float getGrowthMultiplier() {
        return 1.0f;
    }
}
