package mod.azure.azurelib.common.api.common.items;

import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.api.common.helper.AzureGunTypeEnum;
import mod.azure.azurelib.common.api.common.helper.CommonUtils;
import mod.azure.azurelib.common.internal.common.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationController;
import mod.azure.azurelib.common.internal.common.core.animation.RawAnimation;
import mod.azure.azurelib.common.internal.common.core.object.PlayState;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.function.Supplier;

public abstract class AzureBaseGunItem extends class_1792 implements GeoItem {
    protected final AzureGunTypeEnum azureGunTypeEnum;
    private static final String firing = "firing";
    private static final String controller = "controller";
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer(this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache(this);

    public AzureBaseGunItem(AzureGunTypeEnum azureGunTypeEnum, int maxClipSize) {
        super(new class_1793().method_7889(1).method_7895(maxClipSize + 1));
        this.azureGunTypeEnum = azureGunTypeEnum;
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }

    public AzureGunTypeEnum getAzureGunTypeEnum() {
        return this.azureGunTypeEnum;
    }

    public class_1792 getAmmoType() {
        return null;
    }

    public class_3414 getReloadSound() {
        return null;
    }

    public class_3414 getFiringSound() {
        return null;
    }

    public int getReloadAmount() {
        return 1;
    }

    public int getCoolDown() {
        return 1;
    }

    public int getReloadCoolDown() {
        return 1;
    }

    private void singleFire(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1657 player) {
        player.method_7357().method_7906(this, this.getCoolDown());
        CommonUtils.spawnLightSource(player, player.method_37908().method_22351(player.method_24515()));
        itemStack.method_7956(1, player, p -> p.method_20236(player.method_6058()));
    }

    public static void shoot(class_1657 player) {
        if (player.method_6047().method_7919() < (player.method_6047().method_7936() - 1) && player.method_6047().method_7909() instanceof AzureBaseGunItem gunBase) {
            if (!player.method_7357().method_7904(player.method_6047().method_7909()))
                gunBase.singleFire(player.method_6047(), player.method_37908(), player);
        } else {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14962,
                    class_3419.field_15248, 0.25F, 1.3F);
        }
    }


    /**
     * Handles the item reloading.
     *
     * @param user Player who's reloading
     * @param hand Currently only sets the {@link class_1268#field_5808}
     */
    public static void reload(class_1657 user, class_1268 hand) {
        if (user.method_6047().method_7909() instanceof AzureBaseGunItem gunBase) {
            while (!user.method_7337() && user.method_6047().method_7919() != 0 && user.method_31548().method_18861(
                    gunBase.getAmmoType()) > 0) {
                AzureLibUtil.removeAmmo(gunBase.getAmmoType(), user);
                user.method_7357().method_7906(gunBase, gunBase.getReloadCoolDown());
                user.method_6047().method_7956(-gunBase.getReloadAmount(), user,
                        s -> user.method_20236(hand));
                user.method_6047().method_7912(3);
                if (gunBase.getReloadSound() != null)
                    user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), gunBase.getReloadSound(),
                            class_3419.field_15248, 1.00F, 1.0F);
                if (!user.method_37908().field_9236) {
                    gunBase.triggerAnim(user,
                            GeoItem.getOrAssignId(user.method_5998(hand), (class_3218) user.method_37908()),
                            AzureBaseGunItem.controller, "reload");
                }
            }
        }
    }

    @Override
    public @NotNull class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 user, @NotNull class_1268 hand) {
        final var itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return class_1271.method_22428(itemStack);
    }

    @Override
    public int method_7881(@NotNull class_1799 stack) {
        return 72000;
    }

    @Override
    public boolean method_7879(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_2680 blockState, @NotNull class_2338 blockPos, @NotNull class_1309 livingEntity) {
        return false;
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltip, @NotNull class_1836 tooltipFlag) {
        tooltip.add(class_2561.method_43471(
                "Ammo: " + (itemStack.method_7936() - itemStack.method_7919() - 1) + " / " + (itemStack.method_7936() - 1)).method_27692(
                class_124.field_1056));
        super.method_7851(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return renderProvider;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, AzureBaseGunItem.controller,
                event -> PlayState.CONTINUE).triggerableAnim(AzureBaseGunItem.firing,
                RawAnimation.begin().then(AzureBaseGunItem.firing, Animation.LoopType.PLAY_ONCE)).triggerableAnim(
                "reload", RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE)));

    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
}
