package mod.azure.azurelib.common.internal.client;

import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.internal.mixins.ItemRendererAccessor;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_572;
import net.minecraft.class_756;

/**
 * Internal interface for safely providing a custom renderer instances at runtime.<br>
 * This can be safely instantiated as a new anonymous class inside your {@link class_1792} class
 */
public interface RenderProvider {
    RenderProvider DEFAULT = new RenderProvider() {};

    static RenderProvider of(class_1799 itemStack) {
        return of(itemStack.method_7909());
    }

    static RenderProvider of(class_1792 item) {
        if(item instanceof GeoItem geoItem){
            return (RenderProvider)geoItem.getRenderProvider().get();
        }

        return DEFAULT;
    }

    default class_756 getCustomRenderer(){
        return ((ItemRendererAccessor)class_310.method_1551().method_1480()).getBlockEntityRenderer();
    }


    default class_3879 getGenericArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
        class_572<class_1309> replacement = getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);

        if (replacement != original) {
            original.method_2818(replacement);
            return replacement;
        }

        return original;
    }

    default class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
        return original;
    }
}