package mod.azure.azurelib.common.internal.client.config;

import java.util.regex.Pattern;

import mod.azure.azurelib.common.internal.common.config.value.DecimalValue;
import mod.azure.azurelib.common.internal.common.config.value.IntegerValue;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class ClientErrors {

    public static final class_5250 CHAR_VALUE_EMPTY = class_2561.method_43471("text.azurelib.error.character_value_empty");

    private static final String KEY_NAN = "text.azurelib.error.nan";
    private static final String KEY_NUM_BOUNDS = "text.azurelib.error.num_bounds";
    private static final String KEY_MISMATCHED_PATTERN = "text.azurelib.error.pattern_mismatch";

    public static class_5250 notANumber(String value) {
        return class_2561.method_43469(KEY_NAN, value);
    }

    public static class_5250 outOfBounds(int i, IntegerValue.Range range) {
        return class_2561.method_43469(KEY_NUM_BOUNDS, i, range.min(), range.max());
    }

    public static class_5250 outOfBounds(long i, IntegerValue.Range range) {
        return class_2561.method_43469(KEY_NUM_BOUNDS, i, range.min(), range.max());
    }

    public static class_5250 outOfBounds(float i, DecimalValue.Range range) {
        return class_2561.method_43469(KEY_NUM_BOUNDS, i, range.min(), range.max());
    }

    public static class_5250 outOfBounds(double i, DecimalValue.Range range) {
        return class_2561.method_43469(KEY_NUM_BOUNDS, i, range.min(), range.max());
    }

    public static class_5250 invalidText(String text, Pattern pattern) {
        return class_2561.method_43469(KEY_MISMATCHED_PATTERN, text, pattern);
    }
}
