package mod.azure.azurelib.common.internal.client.config.screen;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapter;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapterManager;
import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapters;
import mod.azure.azurelib.common.internal.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.internal.common.config.value.ArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public class ArrayConfigScreen<V, C extends ConfigValue<V> & ArrayValue> extends AbstractConfigScreen {

	public static final class_2561 ADD_ELEMENT = class_2561.method_43471("text.azurelib.value.add_element");

	public final C array;
	private final boolean fixedSize;

	private Supplier<Integer> sizeSupplier = () -> 0;
	private DummyConfigValueFactory valueFactory;
	private ElementAddHandler addHandler;
	private ElementRemoveHandler<V> removeHandler;

	public ArrayConfigScreen(String ownerIdentifier, String configId, C array, class_437 previous) {
		super(class_2561.method_43471(String.format("config.%s.option.%s", configId, ownerIdentifier)), previous, configId);
		this.array = array;
		this.fixedSize = array.isFixedSize();
	}

	public void fetchSize(Supplier<Integer> integerSupplier) {
		this.sizeSupplier = integerSupplier;
	}

	public void valueFactory(DummyConfigValueFactory factory) {
		this.valueFactory = factory;
	}

	public void addElement(ElementAddHandler handler) {
		this.addHandler = handler;
	}

	public void removeElement(ElementRemoveHandler<V> handler) {
		this.removeHandler = handler;
	}

	@Override
	protected void method_25426() {
		final int viewportMin = HEADER_HEIGHT;
		final int viewportHeight = this.field_22790 - viewportMin - FOOTER_HEIGHT;
		this.pageSize = (viewportHeight - 20) / 25;
		this.correctScrollingIndex(this.sizeSupplier.get());
		int errorOffset = (viewportHeight - 20) - (this.pageSize * 25 - 5);
		int offset = 0;

		Class<?> compType = array.get().getClass().getComponentType();
		DisplayAdapter adapter = DisplayAdapterManager.forType(compType);
		TypeAdapter.AdapterContext context = array.getSerializationContext();
		Field owner = context.getOwner();
		for (int i = this.index; i < this.index + this.pageSize; i++) {
			int j = i - this.index;
			if (i >= this.sizeSupplier.get())
				break;
			int correct = errorOffset / (this.pageSize - j);
			errorOffset -= correct;
			offset += correct;
			ConfigValue<?> dummy = valueFactory.create(array.getId(), i);
			dummy.processFieldData(owner);
			ConfigEntryWidget widget = method_37063(new ConfigEntryWidget(30, viewportMin + 10 + j * 25 + offset, this.field_22789 - 60, 20, dummy, this.configId));
			widget.setDescriptionRenderer((graphics, widget1, severity, text) -> renderEntryDescription(graphics, widget1, severity, text));
			if (adapter == null) {
				AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", compType.getSimpleName());
				continue;
			}
			try {
				adapter.placeWidgets(dummy, owner, widget);
				initializeGuiValue(dummy, widget);
			} catch (ClassCastException e) {
				AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", compType.getSimpleName(), e);
			}
			if (!fixedSize) {
				final int elementIndex = i;
				method_37063(class_4185.method_46430(class_2561.method_43470("x"), btn -> {
					this.removeHandler.removeElementAt(elementIndex, (index, src, dest) -> {
						System.arraycopy(src, 0, dest, 0, index);
						System.arraycopy(src, index + 1, dest, index, this.sizeSupplier.get() - 1 - index);
						return dest;
					});
					this.method_25423(field_22787, field_22789, field_22790);
				}).method_46433(this.field_22789 - 28, widget.method_46427()).method_46437(20, 20).method_46431());
			}
		}
		addFooter();
	}

	private void renderEntryDescription(class_332 graphics, class_339 widget, NotificationSeverity severity, List<class_5481> text) {
		if (!severity.isOkStatus()) {
			this.renderNotification(severity, graphics, text, widget.method_46426() + 5, widget.method_46427() + widget.method_25364() + 10);
		}
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		method_25420(graphics, mouseY, mouseY, partialTicks);
		// HEADER
		int titleWidth = this.field_22793.method_27525(this.field_22785);
		graphics.method_51439(this.field_22793, this.field_22785, (int) ((this.field_22789 - titleWidth) / 2.0F), (int) ((HEADER_HEIGHT - this.field_22793.field_2000) / 2.0F), 0xFFFFFF, true);
		graphics.method_25294(0, HEADER_HEIGHT, field_22789, field_22790 - FOOTER_HEIGHT, 0x99 << 24);
		renderScrollbar(graphics, field_22789 - 5, HEADER_HEIGHT, 5, field_22790 - FOOTER_HEIGHT - HEADER_HEIGHT, index, sizeSupplier.get(), pageSize);
		super.method_25394(graphics, mouseX, mouseY, partialTicks);
	}

	@Override
	protected void addFooter() {
		super.addFooter();
		if (!this.fixedSize) {
			int centerY = this.field_22790 - FOOTER_HEIGHT + (FOOTER_HEIGHT - 20) / 2;
			method_37063(class_4185.method_46430(ADD_ELEMENT, btn -> {
				this.addHandler.insertElement();
				this.method_25423(field_22787, field_22789, field_22790);
			}).method_46433(field_22789 - 100, centerY).method_46437(80, 20).method_46431());
		}
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amount, double g) {
		int scale = (int) -amount;
		int next = this.index + scale;
		if (next >= 0 && next + this.pageSize <= this.sizeSupplier.get()) {
			this.index = next;
			this.method_25423(field_22787, field_22789, field_22790);
			return true;
		}
		return false;
	}

	public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
		return new DummyCallbackAdapter<>(componentType, parent, callback, index);
	}

	@FunctionalInterface
	public interface ElementAddHandler {
		void insertElement();
	}

	@FunctionalInterface
	public interface DummyConfigValueFactory {
		ConfigValue<?> create(String id, int elementIndex);
	}

	@FunctionalInterface
	public interface ElementRemoveHandler<V> {
		void removeElementAt(int index, ArrayTrimmer<V> trimmer);

		@FunctionalInterface
		interface ArrayTrimmer<V> {
			V trim(int index, V src, V dest);
		}
	}

	private static class DummyCallbackAdapter<V> implements TypeAdapter.AdapterContext {

		private final TypeAdapter typeAdapter;
		private final Field parentField;
		private final BiConsumer<V, Integer> setCallback;
		private final int index;

		private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
			this.typeAdapter = TypeAdapters.forType(type);
			this.parentField = parentField;
			this.setCallback = setCallback;
			this.index = index;
		}

		@Override
		public TypeAdapter getAdapter() {
			return typeAdapter;
		}

		@Override
		public Field getOwner() {
			return parentField;
		}

		@Override
		public void setFieldValue(Object value) {
			this.setCallback.accept((V) value, this.index);
		}
	}
}
