package mod.azure.azurelib.common.internal.client.config.screen;

import static mod.azure.azurelib.common.internal.client.config.screen.AbstractConfigScreen.FOOTER_HEIGHT;
import static mod.azure.azurelib.common.internal.client.config.screen.AbstractConfigScreen.HEADER_HEIGHT;

import java.util.List;

import mod.azure.azurelib.common.internal.client.config.DisplayAdapter;
import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.config.ConfigHolder;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class ConfigGroupScreen extends class_437 {

	protected final class_437 last;
	protected final String groupId;
	protected final List<ConfigHolder<?>> configHolders;
	protected int index;
	protected int pageSize;

	public ConfigGroupScreen(class_437 last, String groupId, List<ConfigHolder<?>> configHolders) {
		super(class_2561.method_43471("text.azurelib.screen.select_config"));
		this.last = last;
		this.groupId = groupId;
		this.configHolders = configHolders;
	}

	@Override
	protected void method_25426() {
		final int viewportMin = HEADER_HEIGHT;
		final int viewportHeight = this.field_22790 - viewportMin - FOOTER_HEIGHT;
		this.pageSize = (viewportHeight - 20) / 25;
		this.correctScrollingIndex(this.configHolders.size());
		int errorOffset = (viewportHeight - 20) - (this.pageSize * 25 - 5);
		int offset = 0;
		int posX = 30;
		int componentWidth = this.field_22789 - 2 * posX;
		for (int i = this.index; i < this.index + this.pageSize; i++) {
			int j = i - this.index;
			if (i >= configHolders.size())
				break;
			int correct = errorOffset / (this.pageSize - j);
			errorOffset -= correct;
			offset += correct;
			ConfigHolder<?> value = configHolders.get(i);
			int y = viewportMin + 10 + j * 25 + offset;
			String configId = value.getConfigId();
			this.method_37063(new LeftAlignedLabel(posX, y, componentWidth, 20, class_2561.method_43471("config.screen." + configId), this.field_22793));
			this.method_37063(class_4185.method_46430(ConfigEntryWidget.EDIT, btn -> {
				ConfigScreen screen = new ConfigScreen(configId, configId, value.getValueMap(), this);
				field_22787.method_1507(screen);
			}).method_46433(DisplayAdapter.getValueX(posX, componentWidth), y).method_46437(DisplayAdapter.getValueWidth(componentWidth), 20).method_46431());
		}
		initFooter();
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		method_25420(graphics, mouseY, mouseY, partialTicks);
		// HEADER
		int titleWidth = this.field_22793.method_27525(this.field_22785);
		graphics.method_51439(this.field_22793, this.field_22785, (int) ((this.field_22789 - titleWidth) / 2.0F), (int) ((HEADER_HEIGHT - this.field_22793.field_2000) / 2.0F), 0xFFFFFF, true);
		graphics.method_25294(0, HEADER_HEIGHT, field_22789, field_22790 - FOOTER_HEIGHT, 0x99 << 24);
		AbstractConfigScreen.renderScrollbar(graphics, field_22789 - 5, HEADER_HEIGHT, 5, field_22790 - FOOTER_HEIGHT - HEADER_HEIGHT, index, configHolders.size(), pageSize);
		super.method_25394(graphics, mouseX, mouseY, partialTicks);
	}

	protected void initFooter() {
		int centerY = this.field_22790 - FOOTER_HEIGHT + (FOOTER_HEIGHT - 20) / 2;
		method_37063(class_4185.method_46430(ConfigEntryWidget.BACK, btn -> field_22787.method_1507(last)).method_46433(20, centerY).method_46437(50, 20).method_46431());
	}

	protected void correctScrollingIndex(int count) {
		if (index + pageSize > count) {
			index = Math.max(count - pageSize, 0);
		}
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amount, double g) {
		int scale = (int) -amount;
		int next = this.index + scale;
		if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
			this.index = next;
			this.method_25423(field_22787, field_22789, field_22790);
			return true;
		}
		return false;
	}

	protected static final class LeftAlignedLabel extends class_339 {

		private final class_327 font;

		public LeftAlignedLabel(int x, int y, int width, int height, class_2561 label, class_327 font) {
			super(x, y, width, height, label);
			this.font = font;
		}

		@Override
		public void method_47399(class_6382 narrationElementOutput) {
		}

		@Override
		public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
			graphics.method_27535(font, this.method_25369(), this.method_46426(), this.method_46427() + (this.field_22759 - this.font.field_2000) / 2, 0xAAAAAA);
		}

		@Override
		protected boolean method_25351(int p_230987_1_) {
			return false;
		}
	}
}
