package mod.azure.azurelib.common.internal.client.config.screen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapter;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapterManager;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public class ConfigScreen extends AbstractConfigScreen {

	private final Map<String, ConfigValue<?>> valueMap;

	public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
		this(class_2561.method_43471("config.screen." + ownerIdentifier), configId, valueMap, previous);
	}

	public ConfigScreen(class_2561 screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
		super(screenTitle, previous, configId);
		this.valueMap = valueMap;
	}

	@Override
	protected void method_25426() {
		final int viewportMin = HEADER_HEIGHT;
		final int viewportHeight = this.field_22790 - viewportMin - FOOTER_HEIGHT;
		this.pageSize = (viewportHeight - 20) / 25;
		this.correctScrollingIndex(this.valueMap.size());
		List<ConfigValue<?>> values = new ArrayList<>(this.valueMap.values());
		int errorOffset = (viewportHeight - 20) - (this.pageSize * 25 - 5);
		int offset = 0;
		for (int i = this.index; i < this.index + this.pageSize; i++) {
			int j = i - this.index;
			if (i >= values.size())
				break;
			int correct = errorOffset / (this.pageSize - j);
			errorOffset -= correct;
			offset += correct;
			ConfigValue<?> value = values.get(i);
			ConfigEntryWidget widget = method_37063(new ConfigEntryWidget(30, viewportMin + 10 + j * 25 + offset, this.field_22789 - 60, 20, value, this.configId));
			widget.setDescriptionRenderer((graphics, widget1, severity, text) -> renderEntryDescription(graphics, widget1, severity, text));
			TypeAdapter.AdapterContext context = value.getSerializationContext();
			Field field = context.getOwner();
			DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
			if (adapter == null) {
				AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", field.getType().getSimpleName());
				continue;
			}
			try {
				adapter.placeWidgets(value, field, widget);
				initializeGuiValue(value, widget);
			} catch (ClassCastException e) {
				AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", field.getType().getSimpleName(), e);
			}
		}
		this.addFooter();
	}

	private void renderEntryDescription(class_332 graphics, class_339 widget, NotificationSeverity severity, List<class_5481> text) {
		int x = widget.method_46426() + 5;
		int y = widget.method_46427() + widget.method_25364() + 10;
		if (!severity.isOkStatus()) {
			this.renderNotification(severity, graphics, text, x, y);
		} else {
			this.renderNotification(NotificationSeverity.INFO, graphics, text, x, y);
		}
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		method_25420(graphics, mouseY, mouseY, partialTicks);
		// HEADER
		int titleWidth = this.field_22793.method_27525(this.field_22785);
		graphics.method_51439(this.field_22793, this.field_22785, (int) ((this.field_22789 - titleWidth) / 2.0F), (int) ((HEADER_HEIGHT - this.field_22793.field_2000) / 2.0F), 0xFFFFFF, true);
		graphics.method_25294(0, HEADER_HEIGHT, field_22789, field_22790 - FOOTER_HEIGHT, 0x99 << 24);
		renderScrollbar(graphics, field_22789 - 5, HEADER_HEIGHT, 5, field_22790 - FOOTER_HEIGHT - HEADER_HEIGHT, index, valueMap.size(), pageSize);
		super.method_25394(graphics, mouseX, mouseY, partialTicks);
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amount, double g) {
		int scale = (int) -amount;
		int next = this.index + scale;
		if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
			this.index = next;
			this.method_25423(field_22787, field_22789, field_22790);
			return true;
		}
		return false;
	}
}
