package mod.azure.azurelib.common.internal.client.config.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

import mod.azure.azurelib.common.internal.client.config.screen.DialogScreen;
import mod.azure.azurelib.common.internal.common.config.Configurable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;

public final class ColorWidget extends class_339 {

	public static final class_2561 SELECT_COLOR = class_2561.method_43471("text.azurelib.screen.color_dialog");
	private final boolean argb;
	private final String colorPrefix;
	private final IntSupplier colorSupplier;
	private final GetSet<String> colorWidget;
	private final class_437 lastScreen;

	public ColorWidget(int x, int y, int width, int height, Configurable.Gui.ColorValue colorOptions, GetSet<String> colorWidget, class_437 lastScreen) {
		super(x, y, width, height, class_5244.field_39003);
		this.argb = colorOptions.isARGB();
		this.colorPrefix = colorOptions.getGuiColorPrefix();
		this.colorWidget = colorWidget;
		this.colorSupplier = () -> {
			String rawColor = colorWidget.get();
			try {
				long longClr = Long.decode(rawColor);
				return (int) longClr;
			} catch (NumberFormatException e) {
				return 0;
			}
		};
		this.lastScreen = lastScreen;
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialRenderTicks) {
		int borderColor = this.method_25370() ? 0xffffffff : 0xffa0a0a0;
		int providedColor = this.colorSupplier.getAsInt();
		int color = this.argb ? providedColor : (0xFF << 24) | providedColor;
		graphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, borderColor);
		graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFFFFFFFF, 0xFF888888);
		graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, color);
	}

	@Override
	protected boolean method_25351(int button) {
		return button == 0;
	}

	@Override
	public void method_25348(double mouseX, double mouseY) {
		ColorSelectorDialog dialog = new ColorSelectorDialog(SELECT_COLOR, this.lastScreen, this.argb, this.colorSupplier);
		dialog.onConfirmed(screen -> {
			int color = dialog.getResultColor();
			String colorText = this.colorPrefix + Integer.toHexString(color).toUpperCase();
			this.colorWidget.set(colorText);
			dialog.displayPreviousScreen(dialog);
		});
		class_310.method_1551().method_1507(dialog);
	}

	@Override
	public void method_47399(class_6382 elementOutput) {
	}

	public interface GetSet<T> {

		T get();

		void set(T t);

		static <T> GetSet<T> of(Supplier<T> get, Consumer<T> set) {
			return new GetSet<T>() {
				@Override
				public T get() {
					return get.get();
				}

				@Override
				public void set(T t) {
					set.accept(t);
				}
			};
		}
	}

	private static final class ColorSelectorDialog extends DialogScreen {

		private final boolean argb;
		private final IntSupplier colorProvider;
		private final List<ColorSlider> sliders = new ArrayList<>();

		public ColorSelectorDialog(class_2561 title, class_437 background, boolean allowTransparency, IntSupplier colorProvider) {
			super(title, new class_2561[0], background);
			this.argb = allowTransparency;
			this.colorProvider = colorProvider;
		}

		@Override
		protected void method_25426() {
			this.sliders.clear();
			int width = 190;
			int height = 120;
			int rightMargin = 85;
			if (this.argb) {
				height = 150;
				rightMargin = 110;
				width = 230;
			}
			super.method_25426();
			this.setDimensions(width, height);
			int color = this.colorProvider.getAsInt();
			this.sliders.add(this.method_37063(new ColorSlider(dialogLeft + 5, dialogTop + 20, dialogWidth - rightMargin, 20, color, ColorComponent.RED)));
			this.sliders.add(this.method_37063(new ColorSlider(dialogLeft + 5, dialogTop + 45, dialogWidth - rightMargin, 20, color, ColorComponent.GREEN)));
			this.sliders.add(this.method_37063(new ColorSlider(dialogLeft + 5, dialogTop + 70, dialogWidth - rightMargin, 20, color, ColorComponent.BLUE)));
			if (this.argb) {
				this.sliders.add(this.method_37063(new ColorSlider(dialogLeft + 5, dialogTop + 95, dialogWidth - rightMargin, 20, color, ColorComponent.ALPHA)));
			}
			this.method_37063(new ColorDisplay(dialogLeft + 5 + dialogWidth - rightMargin + 5, dialogTop + 20, rightMargin - 15, rightMargin - 15, argb, this::getResultColor));
			super.addDefaultDialogButtons();
		}

		@Override
		protected void addDefaultDialogButtons() {
		}

		public int getResultColor() {
			int color = 0;
			for (ColorSlider slider : this.sliders) {
				color |= slider.getColor();
			}
			return color;
		}

		private static final class ColorDisplay extends class_339 {

			private final boolean argb;
			private final IntSupplier colorProvider;

			public ColorDisplay(int x, int y, int width, int height, boolean argb, IntSupplier colorProvider) {
				super(x, y, width, height, class_5244.field_39003);
				this.argb = argb;
				this.colorProvider = colorProvider;
			}

			@Override
			public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
				int color = this.colorProvider.getAsInt();
				if (!this.argb) {
					color |= 0xFF << 24;
				}
				int borderColor = 0xffa0a0a0;
				graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, borderColor);
				graphics.method_25296(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.field_22758 - 1, this.method_46427() + this.field_22759 - 1, 0xFFFFFFFF, 0xFF888888);
				graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.field_22758 - 1, this.method_46427() + this.field_22759 - 1, color);
			}

			@Override
			protected boolean method_25351(int button) {
				return false;
			}

			@Override
			public void method_47399(class_6382 p_169152_) {
			}
		}

		private static final class ColorSlider extends class_357 {

			private final ColorComponent colorComponent;

			public ColorSlider(int x, int y, int width, int height, int color, ColorComponent colorComponent) {
				super(x, y, width, height, class_5244.field_39003, (colorComponent.getByteColor(color) / 255.0D));
				this.colorComponent = colorComponent;
				this.method_25346();
			}

			@Override
			protected void method_25346() {
				class_2561 colorLabel = this.colorComponent.updateTitle(this.field_22753);
				this.method_25355(colorLabel);
			}

			@Override
			protected void method_25344() {
			}

			int getColor() {
				return this.colorComponent.getOffsetColor((int) (0xFF * this.field_22753));
			}
		}

		private enum ColorComponent {

			ALPHA(24), RED(16), GREEN(8), BLUE(0);

			private final int bitOffset;
			private final Function<Double, class_2561> title;

			ColorComponent(int bitOffset) {
				this.bitOffset = bitOffset;
				this.title = val -> {
					String name = this.name().toLowerCase();
					String translate = "text.azurelib.screen.color." + name;
					int colorValue = (int) (val * 255);
					return class_2561.method_43469(translate, colorValue);
				};
			}

			public int getOffsetColor(int value) {
				return value << bitOffset;
			}

			public int getByteColor(int value) {
				return (value >> bitOffset) & 0xFF;
			}

			public class_2561 updateTitle(double sliderValue) {
				return this.title.apply(sliderValue);
			}
		}
	}
}
