package mod.azure.azurelib.common.internal.client.config.widget;

import Z;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;

public abstract class ContainerWidget extends class_339 implements class_4069 {

	private final List<class_364> listeners = new ArrayList<>();
	private final List<class_339> widgets = new ArrayList<>();
	private class_364 focused;
	private boolean dragging;

	public ContainerWidget(int x, int y, int w, int h, class_2561 component) {
		super(x, y, w, h, component);
	}

	public <L extends class_364> L addGuiEventListener(L listener) {
		this.listeners.add(listener);
		return listener;
	}

	public void removeGuiEventListener(class_364 listener) {
		listeners.remove(listener);
	}

	public <W extends class_339> W addRenderableWidget(W widget) {
		widgets.add(widget);
		return addGuiEventListener(widget);
	}

	public void removeWidget(class_339 widget) {
		widgets.remove(widget);
		removeGuiEventListener(widget);
	}

	public void clear() {
		listeners.clear();
		widgets.clear();
		focused = null;
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		widgets.forEach(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTicks));
	}

	@Override
	public boolean method_25402(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
		var result = class_4069.super.method_25402(p_231044_1_, p_231044_3_, p_231044_5_);
		if (!result && this.focused != null)
			this.method_25395(null);
		return result;
	}

	@Override
	public boolean method_25406(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
		return class_4069.super.method_25406(p_231048_1_, p_231048_3_, p_231048_5_);
	}

	@Override
	public boolean method_25403(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
		return class_4069.super.method_25403(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
	}

	@Override
	public boolean method_25401(double p_231043_1_, double p_231043_3_, double p_231043_5_, double g) {
		return class_4069.super.method_25401(p_231043_1_, p_231043_3_, p_231043_5_, g);
	}

	@Override
	public void method_16014(double p_212927_1_, double p_212927_3_) {
		class_4069.super.method_16014(p_212927_1_, p_212927_3_);
	}

	@Override
	public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
		return class_4069.super.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
	}

	@Override
	public boolean method_16803(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
		return class_4069.super.method_16803(p_223281_1_, p_223281_2_, p_223281_3_);
	}

	@Override
	public List<? extends class_364> method_25396() {
		return listeners;
	}

	@Override
	public boolean method_25397() {
		return dragging;
	}

	@Override
	public void method_25398(boolean dragging) {
		this.dragging = dragging;
	}

	@Override
	public class_364 method_25399() {
		return focused;
	}

	@Override
	public void method_25395(class_364 focused) {
		if (this.focused != null)
			this.focused.method_25365(false);
		if (focused != null)
			focused.method_25365(true);
		this.focused = focused;
	}
}
