package mod.azure.azurelib.common.internal.client.config.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.azure.azurelib.common.internal.common.config.value.EnumValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class EnumWidget<E extends Enum<E>> extends class_339 {
    private static final class_8666 SPRITES = new class_8666(new class_2960("widget/button"), new class_2960("widget/button_disabled"), new class_2960("widget/button_highlighted"));
    private final EnumValue<E> value;

    public EnumWidget(int x, int y, int w, int h, EnumValue<E> value) {
        super(x, y, w, h, class_5244.field_39003);
        this.value = value;
        this.updateText();
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.method_52706(SPRITES.method_52729(this.field_22763, this.method_25367()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        this.renderString(graphics, minecraft.field_1772, class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    private int getTextureY() {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (this.method_25367()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    private void renderString(class_332 graphics, class_327 font, int color) {
        this.method_49604(graphics, font, 2, color);
    }

    @Override
    public void method_25348(double p_230982_1_, double p_230982_3_) {
        this.nextValue();
        this.updateText();
    }

    @Override
    public void method_47399(class_6382 narrationElementOutput) {
    }

    private void nextValue() {
        E e = this.value.get();
        E[] values = e.getDeclaringClass().getEnumConstants();
        int i = e.ordinal();
        int j = (i + 1) % values.length;
        E next = values[j];
        this.value.set(next);
    }

    private void updateText() {
        E e = this.value.get();
        this.method_25355(class_2561.method_43470(e.name()));
    }
}
