package mod.azure.azurelib.common.internal.common;

import java.io.Serial;
import net.minecraft.class_2960;

/**
 * Generic {@link Exception} wrapper for AzureLib.<br>
 * Mostly just serves as a marker for internal error handling.
 */
public class AzureLibException extends RuntimeException {
    @Serial
    private static final long serialVersionUID = 1L;

    public AzureLibException(class_2960 fileLocation, String message) {
        super(fileLocation + ": " + message);
    }

    public AzureLibException(String message, Throwable cause) {
        super(message, cause);
    }

    public AzureLibException(String message) {
        super(message);
    }

    public AzureLibException(Throwable cause) {
        super(cause);
    }

    public AzureLibException(class_2960 fileLocation, String message, Throwable cause) {
        super(fileLocation + ": " + message, cause);
    }
}
