package mod.azure.azurelib.common.internal.common.cache;

import mod.azure.azurelib.common.internal.common.core.animatable.instance.SingletonAnimatableInstanceCache;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_4284;

/**
 * Storage class that keeps track of the last animatable id used, and provides new ones on request.<br>
 * Generally only used for {@link net.minecraft.class_1792 Items}, but any
 * {@link SingletonAnimatableInstanceCache singleton} will likely use this.
 */
public final class AnimatableIdCache extends class_18 {
    private static final String DATA_KEY = "AzureLib_id_cache";
    private long lastId;

    private AnimatableIdCache() {
        this(new class_2487());
    }

    private AnimatableIdCache(class_2487 tag) {
        this.lastId = tag.method_10537("last_id");
    }

    public static class_18.class_8645<AnimatableIdCache> factory() {
        return new class_18.class_8645<AnimatableIdCache>(AnimatableIdCache::new, AnimatableIdCache::new, class_4284.field_45079);
    }

    /**
     * Get the next free id from the id cache
     *
     * @param level An arbitrary ServerLevel. It doesn't matter which one
     * @return The next free ID, which is immediately reserved for use after calling this method
     */
    public static long getFreeId(class_3218 level) {
        return getCache(level).getNextId();
    }

    private long getNextId() {
        method_80();
        return ++this.lastId;
    }

    @Override
    public class_2487 method_75(class_2487 tag) {
        tag.method_10544("last_id", this.lastId);
        return tag;
    }

    private static AnimatableIdCache getCache(class_3218 level) {
        return level.method_8503().method_30002().method_17983().method_17924(AnimatableIdCache.factory(), DATA_KEY);
    }
}
