package mod.azure.azurelib.common.internal.common.config.value;

import mod.azure.azurelib.common.internal.common.config.ConfigUtils;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.internal.common.config.format.IConfigFormat;
import net.minecraft.class_2540;
import java.lang.reflect.Field;

public class FloatValue extends DecimalValue<Float> {

    public FloatValue(ValueData<Float> valueData) {
        super(valueData, Range.unboundedFloat());
    }

    @Override
    public Float getCorrectedValue(Float in) {
        if (this.range == null)
            return in;
        if (!this.range.isWithin(in)) {
            float corrected = this.range.clamp(in);
            ConfigUtils.logCorrectedMessage(this.getId(), in, corrected);
            return corrected;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeFloat(this.getId(), this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readFloat(this.getId()));
    }

    public static final class Adapter extends TypeAdapter {

        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeSerializer serializer, AdapterContext context) throws IllegalAccessException {
            return new FloatValue(ValueData.of(name, (float) value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, class_2540 buffer) {
            buffer.method_52941((Float) value.get());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, class_2540 buffer) {
            return buffer.readFloat();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setFloat(instance, (Float) value);
        }
    }
}
