package mod.azure.azurelib.common.internal.common.loading;

import com.google.gson.JsonObject;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.util.JsonUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelib.common.internal.common.loading.object.BakedAnimations;
import org.apache.commons.io.IOUtils;

import java.io.InputStream;
import java.nio.charset.Charset;

/**
 * Extracts raw information from given files, and other similar functions
 */
public final class FileLoader {
    /**
     * Load up and deserialize an animation json file to its respective {@link Animation} components
     *
     * @param location The resource path of the animations file
     * @param manager  The Minecraft {@code ResourceManager} responsible for maintaining in-memory resource access
     */
    public static BakedAnimations loadAnimationsFile(class_2960 location, class_3300 manager) {
        return JsonUtil.GEO_GSON.fromJson(loadFile(location, manager), BakedAnimations.class);
    }

    /**
     * Load up and deserialize a geo model json file to its respective {@link BakedGeoModel} format
     *
     * @param location The resource path of the model file
     * @param manager  The Minecraft {@code ResourceManager} responsible for maintaining in-memory resource access
     */
    public static Model loadModelFile(class_2960 location, class_3300 manager) {
        return JsonUtil.GEO_GSON.fromJson(loadFile(location, manager), Model.class);
    }

    /**
     * Load a given json file into memory
     *
     * @param location The resource path of the json file
     * @param manager  The Minecraft {@code ResourceManager} responsible for maintaining in-memory resource access
     */
    public static JsonObject loadFile(class_2960 location, class_3300 manager) {
        return class_3518.method_15284(JsonUtil.GEO_GSON, getFileContents(location, manager), JsonObject.class);
    }

    /**
     * Read a text-based file into memory in the form of a single string
     *
     * @param location The resource path of the file
     * @param manager  The Minecraft {@code ResourceManager} responsible for maintaining in-memory resource access
     */
    public static String getFileContents(class_2960 location, class_3300 manager) {
        try (InputStream inputStream = manager.getResourceOrThrow(location).method_14482()) {
            return IOUtils.toString(inputStream, Charset.defaultCharset());
        } catch (Exception e) {
            AzureLib.LOGGER.error("Couldn't load {}", location, e);

            throw new AzureLibException(location.toString());
        }
    }

    private FileLoader() {
        throw new UnsupportedOperationException();
    }
}
