package mod.azure.azurelib.common.internal.common.network;

import mod.azure.azurelib.common.internal.common.core.object.DataTicket;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

/**
 * Network-compatible {@link DataTicket} implementation.
 * Used for sending data from server -> client in an easy manner
 */
public abstract class SerializableDataTicket<D> extends DataTicket<D> {
	protected SerializableDataTicket(String id, Class<? extends D> objectType) {
		super(id, objectType);
	}

	/**
	 * Encode the object to a packet buffer for transmission
	 * @param data The object to be serialized
	 * @param buffer The buffer to serialize the object to
	 */
	public abstract void encode(D data, class_2540 buffer);

	/**
	 * Decode the object from a packet buffer after transmission
	 * @param buffer The buffer to deserialize the object from
	 * @return A new instance of your data object
	 */
	public abstract D decode(class_2540 buffer);

	// Pre-defined typings for use

	/**
	 * Generate a new {@code SerializableDataTicket<Double>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static SerializableDataTicket<Double> ofDouble(class_2960 id) {
		return new SerializableDataTicket<>(id.toString(), Double.class) {
			@Override
			public void encode(Double data, class_2540 buffer) {
				buffer.method_52940(data);
			}

			@Override
			public Double decode(class_2540 buffer) {
				return buffer.readDouble();
			}
		};
	}

	/**
	 * Generate a new {@code SerializableDataTicket<Float>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static SerializableDataTicket<Float> ofFloat(class_2960 id) {
		return new SerializableDataTicket<>(id.toString(), Float.class) {
			@Override
			public void encode(Float data, class_2540 buffer) {
				buffer.method_52941(data);
			}

			@Override
			public Float decode(class_2540 buffer) {
				return buffer.readFloat();
			}
		};
	}

	/**
	 * Generate a new {@code SerializableDataTicket<Boolean>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static SerializableDataTicket<Boolean> ofBoolean(class_2960 id) {
		return new SerializableDataTicket<>(id.toString(), Boolean.class) {
			@Override
			public void encode(Boolean data, class_2540 buffer) {
				buffer.method_52964(data);
			}

			@Override
			public Boolean decode(class_2540 buffer) {
				return buffer.readBoolean();
			}
		};
	}

	/**
	 * Generate a new {@code SerializableDataTicket<Integer>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static SerializableDataTicket<Integer> ofInt(class_2960 id) {
		return new SerializableDataTicket<>(id.toString(), Integer.class) {
			@Override
			public void encode(Integer data, class_2540 buffer) {
				buffer.method_10804(data);
			}

			@Override
			public Integer decode(class_2540 buffer) {
				return buffer.method_10816();
			}
		};
	}

	/**
	 * Generate a new {@code SerializableDataTicket<String>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static SerializableDataTicket<String> ofString(class_2960 id) {
		return new SerializableDataTicket<>(id.toString(), String.class) {
			@Override
			public void encode(String data, class_2540 buffer) {
				buffer.method_10814(data);
			}

			@Override
			public String decode(class_2540 buffer) {
				return buffer.method_19772();
			}
		};
	}

	/**
	 * Generate a new {@code SerializableDataTicket<Enum>} for the given id
	 * @param id The unique id of your ticket. Include your modid
	 */
	public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(class_2960 id, Class<E> enumClass) {
		return new SerializableDataTicket<>(id.toString(), enumClass) {
			@Override
			public void encode(E data, class_2540 buffer) {
				buffer.method_10814(data.toString());
			}

			@Override
			public E decode(class_2540 buffer) {
				return Enum.valueOf(enumClass, buffer.method_19772());
			}
		};
	}
}
