package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import mod.azure.azurelib.common.api.common.animatable.GeoBlockEntity;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;

/**
 * Packet for syncing user-definable animations that can be triggered from the
 * server for {@link net.minecraft.class_2586
 * BlockEntities}
 */
public class BlockEntityAnimTriggerPacket extends AbstractPacket {
    private final class_2338 blockPos;
    private final String controllerName;
    private final String animName;

    public BlockEntityAnimTriggerPacket(class_2338 blockPos, @Nullable String controllerName, String animName) {
        this.blockPos = blockPos;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    @Override
    public void method_53028(class_2540 buf) {
        buf.method_10807(this.blockPos);
        buf.method_10814(this.controllerName);
        buf.method_10814(this.animName);
    }

    @Override
    public class_2960 comp_1678() {
        return AzureLibNetwork.BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static BlockEntityAnimTriggerPacket receive(class_2540 buf) {
        return new BlockEntityAnimTriggerPacket(buf.method_10811(), buf.method_19772(), buf.method_19772());
    }

    @Override
    public void handle() {
        class_2586 blockEntity = ClientUtils.getLevel().method_8321(blockPos);

        if (blockEntity instanceof GeoBlockEntity getBlockEntity) {
            getBlockEntity.triggerAnim(controllerName.isEmpty() ? null : controllerName, animName);
        }
    }
}
