package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.api.common.animatable.GeoEntity;
import mod.azure.azurelib.common.internal.common.constant.DataTickets;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;

/**
 * Packet for syncing user-definable animation data for
 * {@link net.minecraft.class_1297 Entities}
 */
public class EntityAnimDataSyncPacket<D> extends AbstractPacket {
	private final int entityId;
	private final SerializableDataTicket<D> dataTicket;
	private final D data;

	public EntityAnimDataSyncPacket(int entityId, SerializableDataTicket<D> dataTicket, D data) {
		this.entityId = entityId;
		this.dataTicket = dataTicket;
		this.data = data;
	}

	@Override
	public void method_53028(class_2540 buf) {
		buf.method_10804(this.entityId);
		buf.method_10814(this.dataTicket.id());
		this.dataTicket.encode(this.data, buf);
	}

	@Override
	public class_2960 comp_1678() {
		return AzureLibNetwork.ENTITY_ANIM_DATA_SYNC_PACKET_ID;
	}

	public static <D> EntityAnimDataSyncPacket<D> receive(class_2540 buf) {
		int entityId = buf.method_10816();
		SerializableDataTicket<D> dataTicket = (SerializableDataTicket<D>) DataTickets.byName(buf.method_19772());

		return new EntityAnimDataSyncPacket<>(entityId, dataTicket, dataTicket.decode(buf));
	}

	@Override
	public void handle() {
		class_1297 entity = ClientUtils.getLevel().method_8469(entityId);

		if (entity instanceof GeoEntity geoEntity) {
			geoEntity.setAnimData(dataTicket, data);
		}
	}
}
