package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.api.common.animatable.GeoEntity;
import mod.azure.azurelib.common.api.common.animatable.GeoReplacedEntity;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import org.jetbrains.annotations.Nullable;

/**
 * Packet for syncing user-definable animations that can be triggered from the
 * server for {@link net.minecraft.class_1297 Entities}
 */
public class EntityAnimTriggerPacket extends AbstractPacket {
    private final int entityId;
    private final boolean isReplacedEntity;

    private final String controllerName;
    private final String animName;

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public EntityAnimTriggerPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName,
                                   String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    @Override
    public void method_53028(class_2540 buf) {
        buf.method_10804(this.entityId);
        buf.method_52964(this.isReplacedEntity);

        buf.method_10814(this.controllerName);
        buf.method_10814(this.animName);
    }

    @Override
    public class_2960 comp_1678() {
        return AzureLibNetwork.ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static EntityAnimTriggerPacket receive(class_2540 buf) {
        return new EntityAnimTriggerPacket(buf.method_10816(), buf.readBoolean(), buf.method_19772(), buf.method_19772());
    }

    public void handle() {
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity == null)
            return;

        if (!isReplacedEntity) {
            if (entity instanceof GeoEntity geoEntity) {
                geoEntity.triggerAnim(controllerName.isEmpty() ? null : controllerName, animName);
            }
            return;
        }

        GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.method_5864());
        if (animatable instanceof GeoReplacedEntity replacedEntity)
            replacedEntity.triggerAnim(entity, controllerName.isEmpty() ? null : controllerName, animName);
    }
}
