package mod.azure.azurelib.common.internal.common.util;

import mod.azure.azurelib.common.api.common.items.AzureBaseGunItem;
import mod.azure.azurelib.common.internal.common.constant.DataTickets;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.InstancedAnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.core.animation.EasingType;
import mod.azure.azurelib.common.internal.common.core.object.DataTicket;
import mod.azure.azurelib.common.internal.common.loading.object.BakedModelFactory;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

/**
 * Helper class for various AzureLib-specific functions.
 */
public final record AzureLibUtil() {
    /**
     * Creates a new AnimatableInstanceCache for the given animatable object
     *
     * @param animatable The animatable object
     */
    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();

        return cache != null ? cache : createInstanceCache(animatable,
                !(animatable instanceof class_1297) && !(animatable instanceof class_2586));
    }

    /**
     * Creates a new AnimatableInstanceCache for the given animatable object. <br>
     * Recommended to use {@link AzureLibUtil#createInstanceCache(GeoAnimatable)} unless you know what you're doing.
     *
     * @param animatable      The animatable object
     * @param singletonObject Whether the object is a singleton/flyweight object, and uses ints to differentiate animatable instances
     */
    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable, boolean singletonObject) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();

        if (cache != null) return cache;

        return singletonObject ? new SingletonAnimatableInstanceCache(
                animatable) : new InstancedAnimatableInstanceCache(animatable);
    }

    /**
     * Register a custom {@link Animation.LoopType} with AzureLib, allowing for dynamic handling of post-animation looping.<br>
     * <b><u>MUST be called during mod construct</u></b><br>
     *
     * @param name     The name of the {@code LoopType} handler
     * @param loopType The {@code LoopType} implementation to use for the given name
     */
    public static synchronized Animation.LoopType addCustomLoopType(String name, Animation.LoopType loopType) {
        return Animation.LoopType.register(name, loopType);
    }

    /**
     * Register a custom {@link EasingType} with AzureLib, allowing for dynamic handling of animation transitions and curves.<br>
     * <b><u>MUST be called during mod construct</u></b><br>
     *
     * @param name       The name of the {@code EasingType} handler
     * @param easingType The {@code EasingType} implementation to use for the given name
     */
    public static synchronized EasingType addCustomEasingType(String name, EasingType easingType) {
        return EasingType.register(name, easingType);
    }

    /**
     * Register a custom {@link BakedModelFactory} with AzureLib, allowing for dynamic handling of geo model loading.<br>
     * <b><u>MUST be called during mod construct</u></b><br>
     *
     * @param namespace The namespace (modid) to register the factory for
     * @param factory   The factory responsible for model loading under the given namespace
     */
    public static synchronized void addCustomBakedModelFactory(String namespace, BakedModelFactory factory) {
        BakedModelFactory.register(namespace, factory);
    }

    /**
     * Register a custom {@link SerializableDataTicket} with AzureLib for handling custom data transmission.<br>
     * NOTE: You do not need to register non-serializable {@link DataTicket DataTickets}.
     *
     * @param dataTicket The SerializableDataTicket to register
     * @return The dataTicket you passed in
     */
    public static synchronized <D> SerializableDataTicket<D> addDataTicket(SerializableDataTicket<D> dataTicket) {
        return DataTickets.registerSerializable(dataTicket);
    }

    public static boolean checkDistance(class_2338 blockPosA, class_2338 blockPosB, int distance) {
        return Math.abs(blockPosA.method_10263() - blockPosB.method_10263()) <= distance && Math.abs(
                blockPosA.method_10264() - blockPosB.method_10264()) <= distance && Math.abs(
                blockPosA.method_10260() - blockPosB.method_10260()) <= distance;
    }

    public static class_2338 findFreeSpace(class_1937 world, class_2338 blockPos, int maxDistance) {
        if (blockPos == null) return null;

        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets)
            for (int y : offsets)
                for (int z : offsets) {
                    class_2338 offsetPos = blockPos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(offsetPos);
                    if (state.method_26215() || state.method_26204().equals(Services.PLATFORM.getTickingLightBlock()))
                        return offsetPos;
                }
        return null;
    }

    /**
     * Removes matching item from offhand first then checks inventory for item
     *
     * @param ammo         Item you want to be used as ammo
     * @param playerEntity Player whose inventory is being checked.
     */
    public static void removeAmmo(class_1792 ammo, class_1657 playerEntity) {
        if ((playerEntity.method_5998(
                playerEntity.method_6058()).method_7909() instanceof AzureBaseGunItem) && !playerEntity.method_7337()) { // Creative mode reloading breaks things
            for (var item : playerEntity.method_31548().field_7544) {
                if (item.method_7909() == ammo) {
                    item.method_7934(1);
                    break;
                }
                for (var item1 : playerEntity.method_31548().field_7547) {
                    if (item1.method_7909() == ammo) {
                        item1.method_7934(1);
                        break;
                    }
                }
            }
        }
    }
}
