package mod.azure.azurelib.common.internal.mixins;


import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.internal.client.RenderProvider;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Render hook for injecting AzureLib's armor rendering functionalities
 */
@Mixin(value = class_970.class, priority = 700)
public class NeoMixinHumanoidArmorLayer<T extends class_1309, A extends class_572<T>> {

    @Unique
    private class_1309 gl_storedEntity;
    @Unique
    private class_1304 gl_storedSlot;
    @Unique
    private class_1799 gl_storedItemStack;

    @Inject(method = "renderArmorPiece", at = @At(value = "HEAD"))
    public void armorModelHook(class_4587 poseStack, class_4597 source, T livingEntity, class_1304 equipmentSlot, int i, A model, CallbackInfo ci) {
        this.gl_storedEntity = livingEntity;
        this.gl_storedSlot = equipmentSlot;
        this.gl_storedItemStack = livingEntity.method_6118(equipmentSlot);
    }

    @ModifyArg(method = "renderArmorPiece", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;renderModel(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/ArmorItem;Lnet/minecraft/client/model/Model;ZFFFLnet/minecraft/resources/ResourceLocation;)V", remap = false), index = 4)
    public class_3879 injectArmor(class_3879 humanoidModel) {
        return this.gl_storedItemStack.method_7909() instanceof GeoItem ? (A) RenderProvider.of(this.gl_storedItemStack).getGenericArmorModel(this.gl_storedEntity, this.gl_storedItemStack, this.gl_storedSlot, (class_572<class_1309>) humanoidModel) : humanoidModel;    }
}