package mod.azure.azurelib.common.internal.mixins;

import java.util.Map;

import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1060.class)
public abstract class TextureManagerMixin {
	@Shadow @Final private Map<class_2960, class_1044> byPath;

	@Shadow public abstract void register(class_2960 resourceLocation, class_1044 abstractTexture);

	@Inject(method = "getTexture(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/texture/AbstractTexture;", at = @At("HEAD"))
	private void wrapAnimatableTexture(class_2960 path, CallbackInfoReturnable<class_1044> callback) {
		class_1044 existing = this.byPath.get(path);

		if (existing == null) {
			existing = new AnimatableTexture(path);

			register(path, existing);
		}
	}
}