package mod.azure.azurelib.common.platform.services;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

class LockHolder { // Package private class
    public static Object LOCK = new Object();
}

public interface AzureLibNetwork {
    class_2960 ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("anim_data_sync");
    class_2960 ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("anim_trigger_sync");

    class_2960 ENTITY_ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("entity_anim_data_sync");
    class_2960 ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("entity_anim_trigger_sync");

    class_2960 BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("block_entity_anim_data_sync");
    class_2960 BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("block_entity_anim_trigger_sync");
    class_2960 CONFIG_PACKET_ID = AzureLib.modResource("config_packet");

    class_2960 CUSTOM_ENTITY_ID = AzureLib.modResource("spawn_entity");

    class_2960 RELOAD = AzureLib.modResource("reload");

    Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap<>();

    /**
     * Registers a synced {@link GeoAnimatable} object for networking support.<br>
     * It is recommended that you don't call this directly, instead implementing and calling {@link SingletonGeoAnimatable#registerSyncedAnimatable}
     */
    default void registerSyncedAnimatable(GeoAnimatable animatable) {
        synchronized (this) {
            GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);

            if (existing == null)
                AzureLib.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getClass());
        }
    }

    class_2596<?> createPacket(class_1297 entity);

    /**
     * Used to register packets that the server sends
     **/
    void registerClientReceiverPackets();

    void sendToTrackingEntityAndSelf(AbstractPacket packet, class_1297 entityToTrack);

    void sendToEntitiesTrackingChunk(AbstractPacket packet, class_3218 level, class_2338 blockPos);

    void sendClientPacket(class_3222 player, String id);

    static void sendWithCallback(AbstractPacket packet, IPacketCallback callback) {
        callback.onReadyToSend(packet);
    }

    interface IPacketCallback {
        void onReadyToSend(AbstractPacket packetToSend);
    }

    /**
     * Gets a registered synced {@link GeoAnimatable} object by name
     *
     * @param className the className
     */
    @Nullable
    static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);

        if (animatable == null)
            AzureLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");

        return animatable;
    }
}
