package org.Vrglab.AzureLib.Armor;

import mod.azure.azurelib.common.api.client.model.GeoModel;
import mod.azure.azurelib.common.api.client.renderer.GeoArmorRenderer;
import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.internal.client.RenderProvider;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationController;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import org.Vrglab.Modloader.Types.ICallBack;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AzureArmor extends class_1738 implements GeoItem {
    protected final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache(this);
    protected final Supplier<Object> renderProvider = GeoItem.makeRenderer(this);

    public AzureArmor(class_1741 armorMaterial, class_8051 type, class_1793 properties) {
        super(armorMaterial, type, properties);
    }


    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        List<AnimationController> controllerList = (List<AnimationController>)getControllers().accept(controllers);
        for (AnimationController controller: controllerList) {
            controllers.add(controller);
        }
    }

    @Override
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider() {
            private Renderer renderer;

            @Override
            public @NotNull class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (renderer == null)
                    renderer = new Renderer<>(getModel().get());
                renderer.prepForRender(livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return renderProvider;
    }

    /* ABSTRACT FUNCTIONS */
    public abstract ICallBack getControllers();
    public abstract Supplier<GeoModel<? extends AzureArmor>> getModel();


    /* SUB CLASSES */

    public class Renderer<T extends AzureArmor> extends GeoArmorRenderer<T> {
        public Renderer(GeoModel<T> model) {
            super(model);
        }
    }
}
