/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.client.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelib.common.api.client.model.GeoModel;
import mod.azure.azurelib.common.api.client.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.common.api.client.renderer.layer.GeoRenderLayersContainer;
import mod.azure.azurelib.common.api.common.event.GeoRenderObjectEvent;
import mod.azure.azurelib.common.internal.client.renderer.GeoRenderer;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationState;
import mod.azure.azurelib.common.internal.common.core.object.DataTicket;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import org.Vrglab.AzureLib.Utility.Utils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoObjectRenderer<T extends GeoAnimatable>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f objectRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoObjectRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    @Override
    public class_2960 getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation(animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoObjectRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoObjectRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoObjectRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    public void render(class_4587 poseStack, T animatable, @Nullable class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_4588 buffer, int packedLight) {
        this.animatable = animatable;
        class_310 mc = class_310.method_1551();
        if (buffer == null) {
            bufferSource = ((class_4599)Utils.getPrivateFinalStaticField(class_310.method_1551().field_1769, class_310.method_1551().field_1769.getClass(), "renderBuffers")).method_23000();
        }
        this.defaultRender(poseStack, animatable, bufferSource, renderType, buffer, 0.0f, mc.method_1488(), packedLight);
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.objectRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        poseStack.method_46416(0.5f, 0.51f, 0.5f);
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.method_22903();
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            this.model.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (BiConsumer<DataTicket<GeoAnimatable>, GeoAnimatable>)((BiConsumer<DataTicket, GeoAnimatable>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.method_22909();
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.objectRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(this.animatable, 1.0f).method_46409()));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public class_243 getRenderOffset(T entity, float f) {
        return class_243.field_1353;
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(animatable), (int)animatable.getTick(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeoRenderObjectEvent.CompileRenderLayers.EVENT.handle(new GeoRenderObjectEvent.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return GeoRenderObjectEvent.Pre.EVENT.handle(new GeoRenderObjectEvent.Pre(this, poseStack, model, bufferSource, partialTick, packedLight));
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        GeoRenderObjectEvent.Post.EVENT.handle(new GeoRenderObjectEvent.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

