/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.client.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.common.internal.common.cache.AzureLibCache;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.constant.DataTickets;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.model.CoreGeoModel;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationProcessor;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationState;
import mod.azure.azurelib.common.internal.common.core.molang.MolangParser;
import mod.azure.azurelib.common.internal.common.core.object.DataTicket;
import mod.azure.azurelib.common.internal.common.loading.object.BakedAnimations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class GeoModel<T extends GeoAnimatable>
implements CoreGeoModel<T> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract ResourceLocation getModelResource(T var1);

    public abstract ResourceLocation getTextureResource(T var1);

    public abstract ResourceLocation getAnimationResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    @Override
    public final BakedGeoModel getBakedGeoModel(String location) {
        return this.getBakedModel(new ResourceLocation(location));
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = AzureLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new AzureLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    @Override
    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable((GeoBone)this.getAnimationProcessor().getBone(name));
    }

    @Override
    public Animation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = AzureLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            throw new AzureLibException(location, "Unable to find animation.");
        }
        return bakedAnimations.getAnimation(name);
    }

    @Override
    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @Override
    public void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        boolean isReRender;
        Minecraft mc = Minecraft.getInstance();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (animatable instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)animatable;
                d = livingEntity.tickCount;
            } else {
                d = RenderUtils.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)mc.getFrameTime());
        }
        double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!(isReRender || mc.isPaused() && !animatable.shouldPlayAnimsWhileGamePaused())) {
            if (animatable instanceof LivingEntity) {
                animatableManager.updatedAt(currentFrameTime);
            } else {
                animatableManager.updatedAt(currentFrameTime);
            }
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    @Override
    public void applyMolangQueries(T animatable, double animTime) {
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft mc = Minecraft.getInstance();
        parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
        parser.setMemoizedValue("query.actor_count", () -> ((ClientLevel)mc.level).getEntityCount());
        parser.setMemoizedValue("query.time_of_day", () -> (float)mc.level.getDayTime() / 24000.0f);
        parser.setMemoizedValue("query.moon_phase", () -> ((ClientLevel)mc.level).getMoonPhase());
        if (animatable instanceof Entity) {
            Entity entity = (Entity)animatable;
            parser.setMemoizedValue("query.distance_from_camera", () -> mc.gameRenderer.getMainCamera().getPosition().distanceTo(entity.position()));
            parser.setMemoizedValue("query.is_on_ground", () -> RenderUtils.booleanToFloat(entity.onGround()));
            parser.setMemoizedValue("query.is_in_water", () -> RenderUtils.booleanToFloat(entity.isInWater()));
            parser.setMemoizedValue("query.is_in_water_or_rain", () -> RenderUtils.booleanToFloat(entity.isInWaterRainOrBubble()));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                parser.setMemoizedValue("query.health", () -> ((LivingEntity)livingEntity).getHealth());
                parser.setMemoizedValue("query.max_health", () -> ((LivingEntity)livingEntity).getMaxHealth());
                parser.setMemoizedValue("query.is_on_fire", () -> RenderUtils.booleanToFloat(livingEntity.isOnFire()));
                parser.setMemoizedValue("query.ground_speed", () -> {
                    Vec3 velocity = livingEntity.getDeltaMovement();
                    return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
                });
                parser.setMemoizedValue("query.yaw_speed", () -> livingEntity.getViewYRot((float)animTime - livingEntity.getViewYRot((float)animTime - 0.1f)));
            }
        }
    }
}

