/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.animatable;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.internal.common.network.packet.BlockEntityAnimDataSyncPacket;
import mod.azure.azurelib.common.internal.common.network.packet.BlockEntityAnimTriggerPacket;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. ({})", blockEntity.getClass());
            return;
        }
        if (level.isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            BlockPos pos = blockEntity.getBlockPos();
            BlockEntityAnimDataSyncPacket<D> blockEntityAnimDataSyncPacket = new BlockEntityAnimDataSyncPacket<D>(pos, dataTicket, data);
            Services.NETWORK.sendToEntitiesTrackingChunk(blockEntityAnimDataSyncPacket, (ServerLevel)level, pos);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. ({})", blockEntity.getClass());
            return;
        }
        if (level.isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            BlockPos pos = blockEntity.getBlockPos();
            BlockEntityAnimTriggerPacket blockEntityAnimTriggerPacket = new BlockEntityAnimTriggerPacket(pos, controllerName, animName);
            Services.NETWORK.sendToEntitiesTrackingChunk(blockEntityAnimTriggerPacket, (ServerLevel)level, pos);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

