/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class AzureVibrationUser
implements VibrationSystem.User {
    protected final Mob mob;
    protected final float moveSpeed;
    protected final int range;
    protected final PositionSource positionSource;

    public AzureVibrationUser(Mob entity, float speed, int range) {
        this.positionSource = new EntityPositionSource((Entity)entity, entity.getEyeHeight());
        this.mob = entity;
        this.moveSpeed = speed;
        this.range = range;
    }

    public int getListenerRadius() {
        return this.range;
    }

    public PositionSource getPositionSource() {
        return this.positionSource;
    }

    public TagKey<GameEvent> getListenableEvents() {
        return GameEventTags.WARDEN_CAN_LISTEN;
    }

    public boolean canTriggerAvoidVibration() {
        return true;
    }

    public boolean isValidVibration(GameEvent gameEvent, GameEvent.Context context) {
        if (!gameEvent.is(this.getListenableEvents())) {
            return false;
        }
        Entity entity = context.sourceEntity();
        if (entity != null) {
            if (entity.isSpectator()) {
                return false;
            }
            if (entity.isSteppingCarefully() && gameEvent.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                return false;
            }
            if (entity.dampensVibrations()) {
                return false;
            }
        }
        if (context.affectedState() != null) {
            return !context.affectedState().is(BlockTags.DAMPENS_VIBRATIONS);
        }
        return true;
    }

    public boolean canReceiveVibration(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
        if (this.mob.isNoAi() || this.mob.isDeadOrDying() || !this.mob.level().getWorldBorder().isWithinBounds(blockPos) || this.mob.isRemoved()) {
            return false;
        }
        Entity entity = context.sourceEntity();
        return !(entity instanceof LivingEntity) || this.canTargetEntity((Entity)((LivingEntity)entity));
    }

    public void onReceiveVibration(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity2, float f) {
        if (this.mob.isDeadOrDying()) {
            return;
        }
        if (this.mob.isVehicle()) {
            return;
        }
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.mob.level() != entity.level()) {
            return false;
        }
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) {
            return false;
        }
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.isAlliedTo(entity)) {
            return false;
        }
        if (livingEntity.getMobType() == MobType.UNDEAD) {
            return false;
        }
        if (livingEntity.getType() == EntityType.ARMOR_STAND) {
            return false;
        }
        if (livingEntity.getType() == EntityType.WARDEN) {
            return false;
        }
        if (livingEntity instanceof Bat) {
            return false;
        }
        if (entity instanceof Marker) {
            return false;
        }
        if (entity instanceof AreaEffectCloud) {
            return false;
        }
        if (livingEntity.isInvulnerable()) {
            return false;
        }
        if (livingEntity.isDeadOrDying()) {
            return false;
        }
        return this.mob.level().getWorldBorder().isWithinBounds(livingEntity.getBoundingBox());
    }
}

