/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.helper;

import java.util.Optional;
import mod.azure.azurelib.common.internal.common.blocks.TickingLightEntity;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record CommonUtils() {
    public static void summonAoE(LivingEntity entity, ParticleOptions particle, int yOffset, int duration, float radius, boolean hasEffect, @Nullable MobEffect effect, int effectTime) {
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.level(), entity.getX(), entity.getY() + (double)yOffset, entity.getZ());
        areaEffectCloudEntity.setRadius(radius);
        areaEffectCloudEntity.setDuration(duration);
        areaEffectCloudEntity.setParticle(particle);
        areaEffectCloudEntity.setRadiusPerTick(-areaEffectCloudEntity.getRadius() / (float)areaEffectCloudEntity.getDuration());
        if (hasEffect && effect != null && !entity.hasEffect(effect)) {
            areaEffectCloudEntity.addEffect(new MobEffectInstance(effect, effectTime, 0));
        }
        entity.level().addFreshEntity((Entity)areaEffectCloudEntity);
    }

    public static void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        BlockEntity blockEntity;
        BlockPos lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = AzureLibUtil.findFreeSpace(entity.level(), entity.blockPosition(), 2);
            if (lightBlockPos == null) {
                return;
            }
            entity.level().setBlockAndUpdate(lightBlockPos, Services.PLATFORM.getTickingLightBlock().defaultBlockState());
        } else if (AzureLibUtil.checkDistance(lightBlockPos, entity.blockPosition(), 2) && (blockEntity = entity.level().getBlockEntity(lightBlockPos)) instanceof TickingLightEntity) {
            TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
            tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
        }
    }

    public static EntityHitResult hitscanTrace(LivingEntity livingEntity, double range, float ticks) {
        Vec3 look = livingEntity.getViewVector(ticks);
        Vec3 start = livingEntity.getEyePosition(ticks);
        Vec3 end = new Vec3(livingEntity.getX() + look.x * range, livingEntity.getEyeY() + look.y * range, livingEntity.getZ() + look.z * range);
        double traceDistance = livingEntity.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).getLocation().distanceToSqr(end);
        for (Entity possible : livingEntity.level().getEntities((Entity)livingEntity, livingEntity.getBoundingBox().expandTowards(look.scale(traceDistance)).expandTowards(3.0, 3.0, 3.0), entity -> !entity.isSpectator() && entity.isPickable() && entity instanceof LivingEntity)) {
            Optional clip = possible.getBoundingBox().inflate(0.3).clip(start, end);
            if (!clip.isPresent() || !(start.distanceToSqr((Vec3)clip.get()) < traceDistance)) continue;
            return ProjectileUtil.getEntityHitResult((Level)livingEntity.level(), (Entity)livingEntity, (Vec3)start, (Vec3)end, (AABB)livingEntity.getBoundingBox().expandTowards(look.scale(traceDistance)).inflate(3.0, 3.0, 3.0), target -> !target.isSpectator() && livingEntity.isAttackable() && livingEntity.hasLineOfSight(target));
        }
        return null;
    }

    public static void setOnFire(Projectile projectile) {
        if (projectile.isOnFire()) {
            projectile.level().getEntitiesOfClass(LivingEntity.class, projectile.getBoundingBox().inflate(2.0)).forEach(e -> {
                if (e.isAlive() && !(e instanceof Player)) {
                    e.setRemainingFireTicks(90);
                }
            });
        }
    }
}

