/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.items;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.api.common.helper.AzureGunTypeEnum;
import mod.azure.azurelib.common.api.common.helper.CommonUtils;
import mod.azure.azurelib.common.internal.common.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationController;
import mod.azure.azurelib.common.internal.common.core.animation.RawAnimation;
import mod.azure.azurelib.common.internal.common.core.object.PlayState;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AzureBaseGunItem
extends Item
implements GeoItem {
    protected final AzureGunTypeEnum azureGunTypeEnum;
    private static final String firing = "firing";
    private static final String controller = "controller";
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer(this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache(this);

    public AzureBaseGunItem(AzureGunTypeEnum azureGunTypeEnum, int maxClipSize) {
        super(new Item.Properties().stacksTo(1).durability(maxClipSize + 1));
        this.azureGunTypeEnum = azureGunTypeEnum;
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }

    public AzureGunTypeEnum getAzureGunTypeEnum() {
        return this.azureGunTypeEnum;
    }

    public Item getAmmoType() {
        return null;
    }

    public SoundEvent getReloadSound() {
        return null;
    }

    public SoundEvent getFiringSound() {
        return null;
    }

    public int getReloadAmount() {
        return 1;
    }

    public int getCoolDown() {
        return 1;
    }

    public int getReloadCoolDown() {
        return 1;
    }

    private void singleFire(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        player.getCooldowns().addCooldown((Item)this, this.getCoolDown());
        CommonUtils.spawnLightSource((Entity)player, player.level().isWaterAt(player.blockPosition()));
        itemStack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(player.getUsedItemHand()));
    }

    public static void shoot(Player player) {
        Item item;
        if (player.getMainHandItem().getDamageValue() < player.getMainHandItem().getMaxDamage() - 1 && (item = player.getMainHandItem().getItem()) instanceof AzureBaseGunItem) {
            AzureBaseGunItem gunBase = (AzureBaseGunItem)item;
            if (!player.getCooldowns().isOnCooldown(player.getMainHandItem().getItem())) {
                gunBase.singleFire(player.getMainHandItem(), player.level(), player);
            }
        } else {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.25f, 1.3f);
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        Item item = user.getMainHandItem().getItem();
        if (item instanceof AzureBaseGunItem) {
            AzureBaseGunItem gunBase = (AzureBaseGunItem)item;
            while (!user.isCreative() && user.getMainHandItem().getDamageValue() != 0 && user.getInventory().countItem(gunBase.getAmmoType()) > 0) {
                AzureLibUtil.removeAmmo(gunBase.getAmmoType(), user);
                user.getCooldowns().addCooldown((Item)gunBase, gunBase.getReloadCoolDown());
                user.getMainHandItem().hurtAndBreak(-gunBase.getReloadAmount(), (LivingEntity)user, s -> user.broadcastBreakEvent(hand));
                user.getMainHandItem().setPopTime(3);
                if (gunBase.getReloadSound() != null) {
                    user.level().playSound(null, user.getX(), user.getY(), user.getZ(), gunBase.getReloadSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (user.level().isClientSide) continue;
                gunBase.triggerAnim((Entity)user, GeoItem.getOrAssignId(user.getItemInHand(hand), (ServerLevel)user.level()), controller, "reload");
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 72000;
    }

    public boolean mineBlock(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos blockPos, @NotNull LivingEntity livingEntity) {
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Level level, List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)("Ammo: " + (itemStack.getMaxDamage() - itemStack.getDamageValue() - 1) + " / " + (itemStack.getMaxDamage() - 1))).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<AzureBaseGunItem>(this, controller, event -> PlayState.CONTINUE).triggerableAnim(firing, RawAnimation.begin().then(firing, Animation.LoopType.PLAY_ONCE)).triggerableAnim("reload", RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE)));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

