/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client;

import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.internal.mixins.ItemRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface RenderProvider {
    public static final RenderProvider DEFAULT = new RenderProvider(){};

    public static RenderProvider of(ItemStack itemStack) {
        return RenderProvider.of(itemStack.getItem());
    }

    public static RenderProvider of(Item item) {
        if (item instanceof GeoItem) {
            GeoItem geoItem = (GeoItem)item;
            return (RenderProvider)geoItem.getRenderProvider().get();
        }
        return DEFAULT;
    }

    default public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        return ((ItemRendererAccessor)Minecraft.getInstance().getItemRenderer()).getBlockEntityRenderer();
    }

    default public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
        HumanoidModel<LivingEntity> replacement = this.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
        if (replacement != original) {
            original.copyPropertiesTo(replacement);
            return replacement;
        }
        return original;
    }

    default public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
        return original;
    }
}

