/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.common.internal.client.config.IValidationHandler;
import mod.azure.azurelib.common.internal.client.config.screen.ConfigScreen;
import mod.azure.azurelib.common.internal.client.config.screen.DialogScreen;
import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.config.ConfigHolder;
import mod.azure.azurelib.common.internal.common.config.io.ConfigIO;
import mod.azure.azurelib.common.internal.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import mod.azure.azurelib.common.internal.common.config.value.ObjectValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.joml.Matrix4f;

public abstract class AbstractConfigScreen
extends Screen {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    protected final Screen last;
    protected final String configId;
    protected int index;
    protected int pageSize;

    protected AbstractConfigScreen(Component title, Screen previous, String configId) {
        super(title);
        this.last = previous;
        this.configId = configId;
    }

    public void onClose() {
        super.onClose();
        this.saveConfig(true);
    }

    public static void renderScrollbar(GuiGraphics graphics, int x, int y, int width, int height, int index, int valueCount, int paging) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.floor((double)((double)index * step));
        int max = Mth.ceil((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.fill(x, y, x + width, y + height, -16777216);
        graphics.fill(x, y1, x + width, y2, -7829368);
        graphics.fill(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.fill(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addFooter() {
        int centerY = this.height - 30 + 5;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ConfigEntryWidget.BACK, this::buttonBackClicked).pos(20, centerY).size(50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ConfigEntryWidget.REVERT_DEFAULTS, this::buttonRevertToDefaultClicked).pos(75, centerY).size(120, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ConfigEntryWidget.REVERT_CHANGES, this::buttonRevertChangesClicked).pos(200, centerY).size(120, 20).build());
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected Screen getFirstNonConfigScreen() {
        Screen screen = this.last;
        while (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            screen = configScreen.last;
        }
        return screen;
    }

    private void buttonBackClicked(Button button) {
        this.minecraft.setScreen(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            AzureLib.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.configId);
            ConfigHolder.getConfig(this.configId).ifPresent(holder -> {
                this.revertToDefault(holder.values());
                ConfigIO.saveClientValues(holder);
            });
            this.backToConfigList();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void buttonRevertChangesClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::reloadClientValues);
            this.backToConfigList();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else {
                val.useDefaultValue();
            }
        });
    }

    private void backToConfigList() {
        this.minecraft.setScreen(this.getFirstNonConfigScreen());
        this.saveConfig();
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || !(this.last instanceof AbstractConfigScreen)) {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::saveClientValues);
        }
    }

    public void renderNotification(NotificationSeverity severity, GuiGraphics graphics, List<FormattedCharSequence> texts, int mouseX, int mouseY) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            int iconOffset = 13;
            for (FormattedCharSequence textComponent : texts) {
                int textWidth = this.font.width(textComponent);
                if (!severity.isOkStatus()) {
                    textWidth += iconOffset;
                }
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.width) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.height) {
                startY = this.height - heightOffset - 6;
            }
            int background = severity.background;
            int fadeMin = severity.fadeMin;
            int fadeMax = severity.fadeMax;
            int zIndex = 400;
            Tesselator tessellator = Tesselator.getInstance();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder bufferbuilder = tessellator.getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix4f = graphics.pose().last().pose();
            graphics.fillGradient(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.fillGradient(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.fillGradient(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
            if (!severity.isOkStatus()) {
                ResourceLocation icon = severity.getIcon();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
                bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                float min = -0.5f;
                float max = 8.5f;
                bufferbuilder.vertex(matrix4f, (float)startX + min, (float)startY + min, (float)zIndex).uv(0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(matrix4f, (float)startX + min, (float)startY + max, (float)zIndex).uv(0.0f, 1.0f).endVertex();
                bufferbuilder.vertex(matrix4f, (float)startX + max, (float)startY + max, (float)zIndex).uv(1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(matrix4f, (float)startX + max, (float)startY + min, (float)zIndex).uv(1.0f, 0.0f).endVertex();
                BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
            }
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
            int textOffset = severity.isOkStatus() ? 0 : iconOffset;
            for (int i = 0; i < texts.size(); ++i) {
                FormattedCharSequence textComponent = texts.get(i);
                if (textComponent != null) {
                    this.font.drawInBatch(textComponent, (float)startX + (float)textOffset, (float)startY, -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            bufferSource.endBatch();
        }
    }

    protected <T> void initializeGuiValue(ConfigValue<T> value, IValidationHandler handler) {
        T t = value.get();
        value.setWithValidationHandler(t, handler);
    }
}

