/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.screen;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapter;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapterManager;
import mod.azure.azurelib.common.internal.client.config.screen.AbstractConfigScreen;
import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapters;
import mod.azure.azurelib.common.internal.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.internal.common.config.value.ArrayValue;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ArrayConfigScreen<V, C extends ConfigValue<V>>
extends AbstractConfigScreen {
    public static final Component ADD_ELEMENT = Component.translatable((String)"text.azurelib.value.add_element");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V> removeHandler;

    public ArrayConfigScreen(String ownerIdentifier, String configId, C array, Screen previous) {
        super((Component)Component.translatable((String)String.format("config.%s.option.%s", configId, ownerIdentifier)), previous, configId);
        this.array = array;
        this.fixedSize = ((ArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V> handler) {
        this.removeHandler = handler;
    }

    protected void init() {
        int viewportMin = 35;
        int viewportHeight = this.height - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.sizeSupplier.get());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        Class<?> compType = ((ConfigValue)this.array).get().getClass().getComponentType();
        DisplayAdapter adapter = DisplayAdapterManager.forType(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processFieldData(owner);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.addRenderableWidget((GuiEventListener)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.width - 60, 20, dummy, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(dummy, owner, widget);
                this.initializeGuiValue(dummy, widget);
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)compType.getSimpleName(), (Object)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"x"), btn -> {
                this.removeHandler.removeElementAt(elementIndex, (index, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index);
                    System.arraycopy(src, index + 1, dest, index, this.sizeSupplier.get() - 1 - index);
                    return dest;
                });
                this.init(this.minecraft, this.width, this.height);
            }).pos(this.width - 28, widget.getY()).size(20, 20).build());
        }
        this.addFooter();
    }

    private void renderEntryDescription(GuiGraphics graphics, AbstractWidget widget, NotificationSeverity severity, List<FormattedCharSequence> text) {
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, widget.getX() + 5, widget.getY() + widget.getHeight() + 10);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseY, mouseY, partialTicks);
        int titleWidth = this.font.width((FormattedText)this.title);
        int n = (int)((float)(this.width - titleWidth) / 2.0f);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.title, n, (int)((float)(35 - 9) / 2.0f), 0xFFFFFF, true);
        graphics.fill(0, 35, this.width, this.height - 30, -1728053248);
        ArrayConfigScreen.renderScrollbar(graphics, this.width - 5, 35, 5, this.height - 30 - 35, this.index, this.sizeSupplier.get(), this.pageSize);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void addFooter() {
        super.addFooter();
        if (!this.fixedSize) {
            int centerY = this.height - 30 + 5;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)ADD_ELEMENT, btn -> {
                this.addHandler.insertElement();
                this.init(this.minecraft, this.width, this.height);
            }).pos(this.width - 100, centerY).size(80, 20).build());
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double g) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.sizeSupplier.get()) {
            this.index = next;
            this.init(this.minecraft, this.width, this.height);
            return true;
        }
        return false;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapters.forType(type);
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }
}

