/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.screen;

import java.util.Objects;
import mod.azure.azurelib.common.internal.mixins.AccessorWarningScreen;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.multiplayer.WarningScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class OptifineWarningScreen
extends WarningScreen {
    private static final MutableComponent HEADER = Component.translatable((String)"header.azurelib.optifine").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD});
    private static final Component MESSAGE = Component.translatable((String)"message.azurelib.optifine");
    private static final Component CHECK_MESSAGE = Component.translatable((String)"multiplayerWarning.check");
    private static final Component NARRATED_TEXT = HEADER.copy().append("\n").append(MESSAGE);
    private static final Component OPEN_MODS_FOLDER = Component.translatable((String)"label.azurelib.open_mods_folder");
    private static final Component OPTIFINE_ALTERNATIVES = Component.translatable((String)"label.azurelib.optifine_alternatives");
    private static final Component QUIT_GAME = Component.translatable((String)"menu.quit");

    public OptifineWarningScreen() {
        super((Component)HEADER, MESSAGE, CHECK_MESSAGE, NARRATED_TEXT);
    }

    protected void initButtons(int yOffset) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)OPEN_MODS_FOLDER, buttonWidget -> Util.getPlatform().openFile(Services.PLATFORM.modsDir().toFile())).bounds(this.width / 2 - 155, 100 + yOffset, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)OPTIFINE_ALTERNATIVES, buttonWidget -> Util.getPlatform().openUri("https://prismlauncher.org/wiki/getting-started/install-of-alternatives/")).bounds(this.width / 2 - 155 + 160, 100 + yOffset, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)QUIT_GAME, buttonWidget -> this.minecraft.stop()).bounds(this.width / 2 - 75, 130 + yOffset, 150, 20).build());
    }

    protected void init() {
        ((AccessorWarningScreen)((Object)this)).setMessageText(MultiLineLabel.create((Font)this.font, (FormattedText)MESSAGE, (int)(this.width - 50)));
        int n = ((AccessorWarningScreen)((Object)this)).getMessageText().getLineCount() + 1;
        Objects.requireNonNull(this.font);
        int yOffset = n * 9 * 2 - 20;
        this.initButtons(yOffset);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

