/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.util;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import java.util.Map;
import mod.azure.azurelib.common.api.client.model.GeoModel;
import mod.azure.azurelib.common.api.client.renderer.GeoArmorRenderer;
import mod.azure.azurelib.common.api.client.renderer.GeoReplacedEntityRenderer;
import mod.azure.azurelib.common.internal.client.RenderProvider;
import mod.azure.azurelib.common.internal.client.renderer.GeoRenderer;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.model.CoreGeoBone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.Vrglab.AzureLib.Utility.Utils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class RenderUtils {
    public static void translateMatrixToBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, CoreGeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.mulPose(Axis.YP.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vec3 rotation = cube.rotation();
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.z()));
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)rotation.y(), 0.0f));
        poseStack.mulPose(new Quaternionf().rotationXYZ((float)rotation.x(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateToPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(-pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.getInstance();
        try {
            originalTexture = (AbstractTexture)mc.submit(() -> mc.getTextureManager().getTexture(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.getPixels();
            } else {
                nativeImage = NativeImage.read((InputStream)((Resource)mc.getResourceManager().getResource(texture).get()).open());
            }
            image = nativeImage;
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.getWidth(), (int)image.getHeight());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return Blaze3D.getTime() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(ModelPart from, CoreGeoBone to) {
        to.updateRotation(-from.xRot, -from.yRot, from.zRot);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().y() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().x() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().x() == 0.0 || cube.size().y() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(EntityType<?> entityType) {
        GeoModel geoModel;
        EntityRenderer renderer = (EntityRenderer)((Map)Utils.getPrivateFinalStaticField(Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getEntityRenderDispatcher().getClass(), "renderers")).get(entityType);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(EntityType<?> entityType) {
        GeoAnimatable geoAnimatable;
        EntityRenderer renderer = (EntityRenderer)((Map)Utils.getPrivateFinalStaticField(Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getEntityRenderDispatcher().getClass(), "renderers")).get(entityType);
        if (renderer instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)renderer;
            geoAnimatable = (GeoAnimatable)replacedEntityRenderer.getAnimatable();
        } else {
            geoAnimatable = null;
        }
        return geoAnimatable;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(Entity entity) {
        GeoModel geoModel;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(Item item) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = RenderProvider.of(item).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)blockEntityWithoutLevelRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(BlockEntity blockEntity) {
        GeoModel geoModel;
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(ItemStack stack) {
        HumanoidModel<LivingEntity> humanoidModel = RenderProvider.of(stack).getHumanoidArmorModel(null, stack, null, null);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        return null;
    }

    private RenderUtils() {
        throw new UnsupportedOperationException();
    }
}

