/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.animatable;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.internal.common.network.packet.AnimDataSyncPacket;
import mod.azure.azurelib.common.internal.common.network.packet.AnimTriggerPacket;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        Services.NETWORK.registerSyncedAnimatable(animatable);
    }

    @Nullable
    default public <D> D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, relatedEntity);
        }
    }

    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, Entity entityToTrack) {
        Services.NETWORK.sendToTrackingEntityAndSelf(new AnimDataSyncPacket<D>(this.getClass().toString(), instanceId, dataTicket, data), entityToTrack);
    }

    default public void triggerAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
        } else {
            Services.NETWORK.sendToTrackingEntityAndSelf(new AnimTriggerPacket(this.getClass().toString(), instanceId, controllerName, animName), relatedEntity);
        }
    }

    default public void triggerAnim(long instanceId, @Nullable String controllerName, String animName, AzureLibNetwork.IPacketCallback packetCallback) {
        AzureLibNetwork.sendWithCallback(new AnimTriggerPacket(this.getClass().toString(), instanceId, controllerName, animName), packetCallback);
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }

    public void createRenderer(Consumer<Object> var1);

    public Supplier<Object> getRenderProvider();
}

