/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.config.adapter;

import java.util.Objects;
import java.util.function.Predicate;
import mod.azure.azurelib.common.internal.common.AzureLib;
import net.minecraft.resources.ResourceLocation;

public interface TypeMatcher
extends Predicate<Class<?>> {
    public ResourceLocation getIdentifier();

    public int priority();

    public static TypeMatcher matchBoolean() {
        return NamedMatcherImpl.vanilla("boolean", Boolean.TYPE);
    }

    public static TypeMatcher matchCharacter() {
        return NamedMatcherImpl.vanilla("character", Character.TYPE);
    }

    public static TypeMatcher matchInteger() {
        return NamedMatcherImpl.vanilla("integer", Integer.TYPE);
    }

    public static TypeMatcher matchLong() {
        return NamedMatcherImpl.vanilla("long", Long.TYPE);
    }

    public static TypeMatcher matchFloat() {
        return NamedMatcherImpl.vanilla("float", Float.TYPE);
    }

    public static TypeMatcher matchDouble() {
        return NamedMatcherImpl.vanilla("double", Double.TYPE);
    }

    public static TypeMatcher matchString() {
        return NamedMatcherImpl.vanilla("string", String.class);
    }

    public static TypeMatcher matchBooleanArray() {
        return NamedMatcherImpl.vanilla("array/boolean", boolean[].class);
    }

    public static TypeMatcher matchIntegerArray() {
        return NamedMatcherImpl.vanilla("array/integer", int[].class);
    }

    public static TypeMatcher matchLongArray() {
        return NamedMatcherImpl.vanilla("array/long", long[].class);
    }

    public static TypeMatcher matchFloatArray() {
        return NamedMatcherImpl.vanilla("array/float", float[].class);
    }

    public static TypeMatcher matchDoubleArray() {
        return NamedMatcherImpl.vanilla("array/double", double[].class);
    }

    public static TypeMatcher matchStringArray() {
        return NamedMatcherImpl.vanilla("array/string", String[].class);
    }

    public static TypeMatcher matchEnum() {
        return NamedMatcherImpl.vanilla("enum", Class::isEnum);
    }

    public static TypeMatcher matchEnumArray() {
        return NamedMatcherImpl.vanilla("array/enum", type -> type.isArray() && type.getComponentType().isEnum());
    }

    public static TypeMatcher matchObject() {
        return NamedMatcherImpl.vanilla("object", type -> !type.isArray()).withPriority(Integer.MAX_VALUE);
    }

    public static class NamedMatcherImpl
    implements TypeMatcher {
        private final ResourceLocation identifier;
        private final Predicate<Class<?>> matcher;
        private int priority;

        public NamedMatcherImpl(ResourceLocation identifier, Predicate<Class<?>> matcher) {
            this.identifier = Objects.requireNonNull(identifier);
            this.matcher = Objects.requireNonNull(matcher);
        }

        public static NamedMatcherImpl vanilla(String path, Predicate<Class<?>> matcher) {
            return new NamedMatcherImpl(AzureLib.modResource(path), matcher);
        }

        public static NamedMatcherImpl vanilla(String path, Class<?> requiredType) {
            return new NamedMatcherImpl(AzureLib.modResource(path), type -> type.equals(requiredType));
        }

        public NamedMatcherImpl withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public boolean test(Class<?> aClass) {
            return this.matcher.test(aClass);
        }

        @Override
        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        @Override
        public int priority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedMatcherImpl that = (NamedMatcherImpl)o;
            return this.identifier.equals((Object)that.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        public String toString() {
            return "NamedMatcherImpl{identifier=" + String.valueOf(this.identifier) + "}";
        }
    }
}

