/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.internal.common.config.format.IConfigFormat;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import mod.azure.azurelib.common.internal.common.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public final class BooleanValue
extends ConfigValue<Boolean> {
    public BooleanValue(ValueData<Boolean> valueData) {
        super(valueData);
    }

    @Override
    public void serialize(IConfigFormat format) {
        boolean value = (Boolean)this.get();
        format.writeBoolean(this.getId(), value);
    }

    @Override
    public void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        String field = this.getId();
        this.set(format.readBoolean(field));
    }

    public static class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) {
            return new BooleanValue(ValueData.of(name, Boolean.valueOf((Boolean)value), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeBoolean(((Boolean)value.get()).booleanValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            return buffer.readBoolean();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setBoolean(instance, (Boolean)value);
        }
    }
}

