/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Bone;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Cube;
import mod.azure.azurelib.common.internal.common.loading.json.raw.FaceUV;
import mod.azure.azurelib.common.internal.common.loading.json.raw.ModelProperties;
import mod.azure.azurelib.common.internal.common.loading.json.raw.UVUnion;
import mod.azure.azurelib.common.internal.common.loading.object.BoneStructure;
import mod.azure.azurelib.common.internal.common.loading.object.GeometryTree;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface BakedModelFactory {
    public static final Map<String, BakedModelFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    public static final BakedModelFactory DEFAULT_FACTORY = new Builtin();

    public BakedGeoModel constructGeoModel(GeometryTree var1);

    public GeoBone constructBone(BoneStructure var1, ModelProperties var2, @Nullable GeoBone var3);

    public GeoCube constructCube(Cube var1, ModelProperties var2, GeoBone var3);

    default public GeoQuad[] buildQuads(UVUnion uvUnion, VertexSet vertices, Cube cube, float textureWidth, float textureHeight, boolean mirror) {
        GeoQuad[] quads = new GeoQuad[]{this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.WEST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.EAST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.NORTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.SOUTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.UP), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.DOWN)};
        return quads;
    }

    default public GeoQuad buildQuad(VertexSet vertices, Cube cube, UVUnion uvUnion, float textureWidth, float textureHeight, boolean mirror, Direction direction) {
        double[][] dArrayArray;
        if (!uvUnion.isBoxUV()) {
            FaceUV faceUV = uvUnion.faceUV().fromDirection(direction);
            if (faceUV == null) {
                return null;
            }
            return GeoQuad.build(vertices.verticesForQuad(direction, false, mirror || cube.mirror() == Boolean.TRUE), faceUV.uv(), faceUV.uvSize(), textureWidth, textureHeight, mirror, direction);
        }
        double[] uv = cube.uv().boxUVCoords();
        double[] uvSize = cube.size();
        Vec3 uvSizeVec = new Vec3(Math.floor(uvSize[0]), Math.floor(uvSize[1]), Math.floor(uvSize[2]));
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WEST: {
                double[][] dArrayArray2 = new double[2][];
                dArrayArray2[0] = new double[]{uv[0] + uvSizeVec.z + uvSizeVec.x, uv[1] + uvSizeVec.z};
                dArrayArray = dArrayArray2;
                dArrayArray2[1] = new double[]{uvSizeVec.z, uvSizeVec.y};
                break;
            }
            case EAST: {
                double[][] dArrayArray3 = new double[2][];
                dArrayArray3[0] = new double[]{uv[0], uv[1] + uvSizeVec.z};
                dArrayArray = dArrayArray3;
                dArrayArray3[1] = new double[]{uvSizeVec.z, uvSizeVec.y};
                break;
            }
            case NORTH: {
                double[][] dArrayArray4 = new double[2][];
                dArrayArray4[0] = new double[]{uv[0] + uvSizeVec.z, uv[1] + uvSizeVec.z};
                dArrayArray = dArrayArray4;
                dArrayArray4[1] = new double[]{uvSizeVec.x, uvSizeVec.y};
                break;
            }
            case SOUTH: {
                double[][] dArrayArray5 = new double[2][];
                dArrayArray5[0] = new double[]{uv[0] + uvSizeVec.z + uvSizeVec.x + uvSizeVec.z, uv[1] + uvSizeVec.z};
                dArrayArray = dArrayArray5;
                dArrayArray5[1] = new double[]{uvSizeVec.x, uvSizeVec.y};
                break;
            }
            case UP: {
                double[][] dArrayArray6 = new double[2][];
                dArrayArray6[0] = new double[]{uv[0] + uvSizeVec.z, uv[1]};
                dArrayArray = dArrayArray6;
                dArrayArray6[1] = new double[]{uvSizeVec.x, uvSizeVec.z};
                break;
            }
            case DOWN: {
                double[][] dArrayArray7 = new double[2][];
                dArrayArray7[0] = new double[]{uv[0] + uvSizeVec.z + uvSizeVec.x, uv[1] + uvSizeVec.z};
                dArrayArray = dArrayArray7;
                dArrayArray7[1] = new double[]{uvSizeVec.x, -uvSizeVec.z};
            }
        }
        double[][] uvData = dArrayArray;
        return GeoQuad.build(vertices.verticesForQuad(direction, true, mirror || cube.mirror() == Boolean.TRUE), uvData[0], uvData[1], textureWidth, textureHeight, mirror, direction);
    }

    public static BakedModelFactory getForNamespace(String namespace) {
        return FACTORIES.getOrDefault(namespace, DEFAULT_FACTORY);
    }

    public static void register(String namespace, BakedModelFactory factory) {
        FACTORIES.put(namespace, factory);
    }

    public record VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
        public VertexSet(Vec3 origin, Vec3 vertexSize, double inflation) {
            this(new GeoVertex(origin.x - inflation, origin.y - inflation, origin.z - inflation), new GeoVertex(origin.x - inflation, origin.y - inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new GeoVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z - inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z + vertexSize.z + inflation));
        }

        public GeoVertex[] quadWest() {
            return new GeoVertex[]{this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack};
        }

        public GeoVertex[] quadEast() {
            return new GeoVertex[]{this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront};
        }

        public GeoVertex[] quadNorth() {
            return new GeoVertex[]{this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack};
        }

        public GeoVertex[] quadSouth() {
            return new GeoVertex[]{this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront};
        }

        public GeoVertex[] quadUp() {
            return new GeoVertex[]{this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack};
        }

        public GeoVertex[] quadDown() {
            return new GeoVertex[]{this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack};
        }

        public GeoVertex[] verticesForQuad(Direction direction, boolean boxUv, boolean mirror) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.WEST -> {
                    if (mirror) {
                        yield this.quadEast();
                    }
                    yield this.quadWest();
                }
                case Direction.EAST -> {
                    if (mirror) {
                        yield this.quadWest();
                    }
                    yield this.quadEast();
                }
                case Direction.NORTH -> this.quadNorth();
                case Direction.SOUTH -> this.quadSouth();
                case Direction.UP -> {
                    if (mirror && !boxUv) {
                        yield this.quadDown();
                    }
                    yield this.quadUp();
                }
                case Direction.DOWN -> mirror && !boxUv ? this.quadUp() : this.quadDown();
            };
        }
    }

    public static final class Builtin
    implements BakedModelFactory {
        @Override
        public BakedGeoModel constructGeoModel(GeometryTree geometryTree) {
            ObjectArrayList bones = new ObjectArrayList();
            for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
                bones.add(this.constructBone(boneStructure, geometryTree.properties(), null));
            }
            return new BakedGeoModel((List<GeoBone>)bones, geometryTree.properties());
        }

        @Override
        public GeoBone constructBone(BoneStructure boneStructure, ModelProperties properties, GeoBone parent) {
            Bone bone = boneStructure.self();
            GeoBone newBone = new GeoBone(parent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
            Vec3 rotation = RenderUtils.arrayToVec(bone.rotation());
            Vec3 pivot = RenderUtils.arrayToVec(bone.pivot());
            newBone.updateRotation((float)Math.toRadians(-rotation.x), (float)Math.toRadians(-rotation.y), (float)Math.toRadians(rotation.z));
            newBone.updatePivot((float)(-pivot.x), (float)pivot.y, (float)pivot.z);
            for (Cube cube : bone.cubes()) {
                newBone.getCubes().add(this.constructCube(cube, properties, newBone));
            }
            for (BoneStructure child : boneStructure.children().values()) {
                newBone.getChildBones().add(this.constructBone(child, properties, newBone));
            }
            return newBone;
        }

        @Override
        public GeoCube constructCube(Cube cube, ModelProperties properties, GeoBone bone) {
            boolean mirror;
            boolean bl = mirror = cube.mirror() == Boolean.TRUE;
            double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
            Vec3 size = RenderUtils.arrayToVec(cube.size());
            Vec3 origin = RenderUtils.arrayToVec(cube.origin());
            Vec3 rotation = RenderUtils.arrayToVec(cube.rotation());
            Vec3 pivot = RenderUtils.arrayToVec(cube.pivot());
            origin = new Vec3(-(origin.x + size.x) / 16.0, origin.y / 16.0, origin.z / 16.0);
            Vec3 vertexSize = size.multiply(0.0625, 0.0625, 0.0625);
            pivot = pivot.multiply(-1.0, 1.0, 1.0);
            rotation = new Vec3(Math.toRadians(-rotation.x), Math.toRadians(-rotation.y), Math.toRadians(rotation.z));
            GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
            return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
        }
    }
}

