/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.screen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapter;
import mod.azure.azurelib.common.internal.client.config.DisplayAdapterManager;
import mod.azure.azurelib.common.internal.client.config.screen.AbstractConfigScreen;
import mod.azure.azurelib.common.internal.client.config.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
        this((class_2561)class_2561.method_43471((String)("config.screen." + ownerIdentifier)), configId, valueMap, previous);
    }

    public ConfigScreen(class_2561 screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.method_37063((class_364)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.field_22789 - 60, 20, value, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(class_332 graphics, class_339 widget, NotificationSeverity severity, List<class_5481> text) {
        int x = widget.method_46426() + 5;
        int y = widget.method_46427() + widget.method_25364() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, graphics, text, x, y);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseY, mouseY, partialTicks);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int n = (int)((float)(this.field_22789 - titleWidth) / 2.0f);
        Objects.requireNonNull(this.field_22793);
        graphics.method_51439(this.field_22793, this.field_22785, n, (int)((float)(35 - 9) / 2.0f), 0xFFFFFF, true);
        graphics.method_25294(0, 35, this.field_22789, this.field_22790 - 30, -1728053248);
        ConfigScreen.renderScrollbar(graphics, this.field_22789 - 5, 35, 5, this.field_22790 - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount, double g) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }
}

