/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import org.jetbrains.annotations.Nullable;

public abstract class GeoAbstractTexture
extends class_1044 {
    protected static void generateTexture(class_2960 texturePath, Consumer<class_1060> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (!(textureManager.method_34590(texturePath, (class_1044)class_1047.method_4540()) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public final void method_4625(class_3300 resourceManager) throws IOException {
        class_4573 renderCall = this.loadTexture(resourceManager, class_310.method_1551());
        if (renderCall == null) {
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected void printDebugImageToDisk(class_2960 id, class_1011 newImage) {
        try {
            File file = new File(Services.PLATFORM.getGameDir().toFile(), "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.method_12832().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.method_4325(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    protected abstract class_4573 loadTexture(class_3300 var1, class_310 var2) throws IOException;

    public static void uploadSimple(int texture, class_1011 image, boolean blur, boolean clamp) {
        TextureUtil.prepareImage((int)texture, (int)0, (int)image.method_4307(), (int)image.method_4323());
        image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), blur, clamp, false, true);
    }

    public static class_2960 appendToPath(class_2960 location, String suffix) {
        String path = location.method_12832();
        int i = path.lastIndexOf(46);
        return new class_2960(location.method_12836(), path.substring(0, i) + suffix + path.substring(i));
    }
}

