/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mod.azure.azurelib.common.internal.common.core.animation.Animation;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Bone;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Cube;
import mod.azure.azurelib.common.internal.common.loading.json.raw.FaceUV;
import mod.azure.azurelib.common.internal.common.loading.json.raw.LocatorClass;
import mod.azure.azurelib.common.internal.common.loading.json.raw.LocatorValue;
import mod.azure.azurelib.common.internal.common.loading.json.raw.MinecraftGeometry;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelib.common.internal.common.loading.json.raw.ModelProperties;
import mod.azure.azurelib.common.internal.common.loading.json.raw.PolyMesh;
import mod.azure.azurelib.common.internal.common.loading.json.raw.PolysUnion;
import mod.azure.azurelib.common.internal.common.loading.json.raw.TextureMesh;
import mod.azure.azurelib.common.internal.common.loading.json.raw.UVFaces;
import mod.azure.azurelib.common.internal.common.loading.json.raw.UVUnion;
import mod.azure.azurelib.common.internal.common.loading.json.typeadapter.BakedAnimationsAdapter;
import mod.azure.azurelib.common.internal.common.loading.json.typeadapter.KeyFramesAdapter;
import mod.azure.azurelib.common.internal.common.loading.object.BakedAnimations;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public final class JsonUtil {
    public static final Gson GEO_GSON = new GsonBuilder().setLenient().registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(MinecraftGeometry.class, MinecraftGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(ModelProperties.class, ModelProperties.deserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).registerTypeAdapter(Animation.Keyframes.class, (Object)new KeyFramesAdapter()).registerTypeAdapter(BakedAnimations.class, (Object)new BakedAnimationsAdapter()).create();

    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            output[i] = array.get(i).getAsDouble();
        }
        return output;
    }

    public static <T> T[] jsonArrayToObjectArray(JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i = 0; i < array.size(); ++i) {
            objArray[i] = context.deserialize(array.get(i), objectClass);
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> Map<String, T> jsonObjToMap(JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put((String)entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map;
    }

    @Nullable
    public static Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(class_3518.method_22449((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(class_3518.method_15270((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(class_3518.method_15259((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(class_3518.method_34927((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(class_3518.method_15260((JsonObject)obj, (String)elementName)) : null;
    }
}

