/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler;

import javassist.CannotCompileException;
import javassist.NotFoundException;
import javassist.compiler.Lex;

public class CompileError
extends Exception {
    private static final long serialVersionUID = 1L;
    private Lex lex;
    private String reason;
    private int lineNumber = -1;

    public CompileError(String s, Lex l) {
        this(s, l.getLineNumber());
        this.lex = l;
    }

    public CompileError(String s, int lineNumber) {
        this.lineNumber = lineNumber;
        this.reason = String.format("line %d: %s", lineNumber, s);
    }

    private CompileError(String s) {
        this.reason = s;
        this.lex = null;
    }

    public CompileError(CannotCompileException e) {
        this(e.getReason());
    }

    public CompileError(NotFoundException e) {
        this("cannot find " + e.getMessage());
    }

    public Lex getLex() {
        return this.lex;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        return this.reason;
    }

    @Override
    public String toString() {
        return "compile error: " + this.reason;
    }
}

