/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class BootstrapMethodsAttribute
extends AttributeInfo {
    public static final String tag = "BootstrapMethods";

    BootstrapMethodsAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public BootstrapMethodsAttribute(ConstPool cp, BootstrapMethod[] methods) {
        super(cp, tag);
        this.set(BootstrapMethodsAttribute.convertMethodsToBytes(methods));
    }

    public BootstrapMethod[] getMethods() {
        byte[] data = this.get();
        int num = ByteArray.readU16bit(data, 0);
        BootstrapMethod[] methods = new BootstrapMethod[num];
        int pos = 2;
        for (int i = 0; i < num; ++i) {
            int ref = ByteArray.readU16bit(data, pos);
            int len = ByteArray.readU16bit(data, pos + 2);
            int[] args = new int[len];
            pos += 4;
            for (int k = 0; k < len; ++k) {
                args[k] = ByteArray.readU16bit(data, pos);
                pos += 2;
            }
            methods[i] = new BootstrapMethod(ref, args);
        }
        return methods;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        BootstrapMethod[] methods = this.getMethods();
        ConstPool thisCp = this.getConstPool();
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = methods[i].copy(thisCp, newCp, classnames);
        }
        return new BootstrapMethodsAttribute(newCp, methods);
    }

    public void addMethod(ConstPool srcCp, BootstrapMethod srcBm, int index, Map<String, String> classnames) {
        BootstrapMethod[] methods = this.getMethods();
        if (index < 0 || index > methods.length) {
            throw new RuntimeException("index out of range");
        }
        if (index == methods.length) {
            BootstrapMethod[] newBmArray = new BootstrapMethod[methods.length + 1];
            System.arraycopy(methods, 0, newBmArray, 0, methods.length);
            methods = newBmArray;
        }
        methods[index] = srcBm.copy(srcCp, this.getConstPool(), classnames);
        this.set(BootstrapMethodsAttribute.convertMethodsToBytes(methods));
    }

    private static byte[] convertMethodsToBytes(BootstrapMethod[] methods) {
        int size = 2;
        for (int i = 0; i < methods.length; ++i) {
            size += 4 + methods[i].arguments.length * 2;
        }
        byte[] data = new byte[size];
        ByteArray.write16bit(methods.length, data, 0);
        int pos = 2;
        for (int i = 0; i < methods.length; ++i) {
            ByteArray.write16bit(methods[i].methodRef, data, pos);
            ByteArray.write16bit(methods[i].arguments.length, data, pos + 2);
            int[] args = methods[i].arguments;
            pos += 4;
            for (int k = 0; k < args.length; ++k) {
                ByteArray.write16bit(args[k], data, pos);
                pos += 2;
            }
        }
        return data;
    }

    public static class BootstrapMethod {
        public int methodRef;
        public int[] arguments;

        public BootstrapMethod(int method, int[] args) {
            this.methodRef = method;
            this.arguments = args;
        }

        protected BootstrapMethod copy(ConstPool srcCp, ConstPool destCp, Map<String, String> classnames) {
            int newMethodRef = srcCp.copy(this.methodRef, destCp, classnames);
            int[] newArguments = new int[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                newArguments[i] = srcCp.copy(this.arguments[i], destCp, classnames);
            }
            return new BootstrapMethod(newMethodRef, newArguments);
        }
    }
}

