/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LineNumberAttribute;
import javassist.compiler.ast.ASTree;

public class LineNumberAttributeBuilder {
    private final HashMap<Integer, Integer> map = new HashMap();

    public void put(int newPc, ASTree tree) {
        if (tree != null) {
            this.put(newPc, tree.getLineNumber());
        }
    }

    private void put(int newPc, int lineNum) {
        Integer pc = this.map.get(lineNum);
        if (pc == null || newPc < pc) {
            this.map.put(lineNum, newPc);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LineNumberAttribute build(ConstPool cp) {
        int size = this.map.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 4 + 2);){
            LineNumberAttribute lineNumberAttribute;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeShort(size);
                for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
                    dos.writeShort(entry.getValue());
                    dos.writeShort(entry.getKey());
                }
                lineNumberAttribute = new LineNumberAttribute(cp, bos.toByteArray());
            }
            return lineNumberAttribute;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

